/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.exps.ExpContext;
import org.apache.openjpa.jdbc.kernel.exps.ExpState;
import org.apache.openjpa.jdbc.kernel.exps.FilterValue;
import org.apache.openjpa.jdbc.kernel.exps.Val;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.DataSourceFactory;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.schema.NameSet;
import org.apache.openjpa.jdbc.schema.PrimaryKey;
import org.apache.openjpa.jdbc.schema.Schema;
import org.apache.openjpa.jdbc.schema.SchemaGroup;
import org.apache.openjpa.jdbc.schema.Sequence;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.schema.Unique;
import org.apache.openjpa.jdbc.sql.Calendard;
import org.apache.openjpa.jdbc.sql.DBDictionaryFactory;
import org.apache.openjpa.jdbc.sql.Join;
import org.apache.openjpa.jdbc.sql.JoinSyntaxes;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.jdbc.sql.Sized;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.jdbc.ConnectionDecorator;
import org.apache.openjpa.lib.jdbc.LoggingConnectionDecorator;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.JavaTypes;
import org.apache.openjpa.util.GeneralException;
import org.apache.openjpa.util.InvalidStateException;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.ReferentialIntegrityException;
import org.apache.openjpa.util.Serialization;
import org.apache.openjpa.util.StoreException;
import org.apache.openjpa.util.UnsupportedException;
import org.apache.openjpa.util.UserException;
import serp.util.Numbers;
import serp.util.Strings;

public class DBDictionary
implements Configurable,
ConnectionDecorator,
JoinSyntaxes,
LoggingConnectionDecorator.SQLWarningHandler {
    public static final String VENDOR_OTHER = "other";
    public static final String VENDOR_DATADIRECT = "datadirect";
    public static final String SCHEMA_CASE_UPPER = "upper";
    public static final String SCHEMA_CASE_LOWER = "lower";
    public static final String SCHEMA_CASE_PRESERVE = "preserve";
    public static final String CONS_NAME_BEFORE = "before";
    public static final String CONS_NAME_MID = "mid";
    public static final String CONS_NAME_AFTER = "after";
    protected static final int RANGE_POST_SELECT = 0;
    protected static final int RANGE_PRE_DISTINCT = 1;
    protected static final int RANGE_POST_DISTINCT = 2;
    protected static final int RANGE_POST_LOCK = 3;
    protected static final int NANO = 1;
    protected static final int MICRO = 1000;
    protected static final int MILLI = 1000000;
    protected static final int CENTI = 10000000;
    protected static final int DECI = 100000000;
    protected static final int SEC = 1000000000;
    protected static final int NAME_ANY = 0;
    protected static final int NAME_TABLE = 1;
    protected static final int NAME_SEQUENCE = 2;
    private static final String ZERO_DATE_STR = "'" + new java.sql.Date(0L) + "'";
    private static final String ZERO_TIME_STR = "'" + new Time(0L) + "'";
    private static final String ZERO_TIMESTAMP_STR = "'" + new Timestamp(0L) + "'";
    private static final Localizer _loc = Localizer.forPackage(DBDictionary.class);
    public String platform = "Generic";
    public String driverVendor = null;
    public String catalogSeparator = ".";
    public boolean createPrimaryKeys = true;
    public String constraintNameMode = "before";
    public int maxTableNameLength = 128;
    public int maxColumnNameLength = 128;
    public int maxConstraintNameLength = 128;
    public int maxIndexNameLength = 128;
    public int maxIndexesPerTable = Integer.MAX_VALUE;
    public boolean supportsForeignKeys = true;
    public boolean supportsTimestampNanos = true;
    public boolean supportsUniqueConstraints = true;
    public boolean supportsDeferredConstraints = true;
    public boolean supportsRestrictDeleteAction = true;
    public boolean supportsCascadeDeleteAction = true;
    public boolean supportsNullDeleteAction = true;
    public boolean supportsDefaultDeleteAction = true;
    public boolean supportsRestrictUpdateAction = true;
    public boolean supportsCascadeUpdateAction = true;
    public boolean supportsNullUpdateAction = true;
    public boolean supportsDefaultUpdateAction = true;
    public boolean supportsAlterTableWithAddColumn = true;
    public boolean supportsAlterTableWithDropColumn = true;
    public String reservedWords = null;
    public String systemSchemas = null;
    public String systemTables = null;
    public String fixedSizeTypeNames = null;
    public String schemaCase = "upper";
    public String validationSQL = null;
    public String closePoolSQL = null;
    public String initializationSQL = null;
    public int joinSyntax = 0;
    public String outerJoinClause = "LEFT OUTER JOIN";
    public String innerJoinClause = "INNER JOIN";
    public String crossJoinClause = "CROSS JOIN";
    public boolean requiresConditionForCrossJoin = false;
    public String forUpdateClause = "FOR UPDATE";
    public String tableForUpdateClause = null;
    public String distinctCountColumnSeparator = null;
    public boolean supportsSelectForUpdate = true;
    public boolean supportsLockingWithDistinctClause = true;
    public boolean supportsLockingWithMultipleTables = true;
    public boolean supportsLockingWithOrderClause = true;
    public boolean supportsLockingWithOuterJoin = true;
    public boolean supportsLockingWithInnerJoin = true;
    public boolean supportsLockingWithSelectRange = true;
    public boolean supportsQueryTimeout = true;
    public boolean simulateLocking = false;
    public boolean supportsSubselect = true;
    public boolean supportsCorrelatedSubselect = true;
    public boolean supportsHaving = true;
    public boolean supportsSelectStartIndex = false;
    public boolean supportsSelectEndIndex = false;
    public int rangePosition = 0;
    public boolean requiresAliasForSubselect = false;
    public boolean allowsAliasInBulkClause = true;
    public boolean supportsMultipleNontransactionalResultSets = true;
    public String searchStringEscape = "\\";
    public boolean requiresCastForMathFunctions = false;
    public boolean requiresCastForComparisons = false;
    public boolean supportsModOperator = false;
    public String castFunction = "CAST({0} AS {1})";
    public String toLowerCaseFunction = "LOWER({0})";
    public String toUpperCaseFunction = "UPPER({0})";
    public String stringLengthFunction = "CHAR_LENGTH({0})";
    public String bitLengthFunction = "(OCTET_LENGTH({0}) * 8)";
    public String trimLeadingFunction = "TRIM(LEADING {1} FROM {0})";
    public String trimTrailingFunction = "TRIM(TRAILING {1} FROM {0})";
    public String trimBothFunction = "TRIM(BOTH {1} FROM {0})";
    public String concatenateFunction = "({0}||{1})";
    public String concatenateDelimiter = "'OPENJPATOKEN'";
    public String substringFunctionName = "SUBSTRING";
    public String currentDateFunction = "CURRENT_DATE";
    public String currentTimeFunction = "CURRENT_TIME";
    public String currentTimestampFunction = "CURRENT_TIMESTAMP";
    public String dropTableSQL = "DROP TABLE {0}";
    public boolean storageLimitationsFatal = false;
    public boolean storeLargeNumbersAsStrings = false;
    public boolean storeCharsAsNumbers = true;
    public boolean useGetBytesForBlobs = false;
    public boolean useSetBytesForBlobs = false;
    public boolean useGetObjectForBlobs = false;
    public boolean useGetStringForClobs = false;
    public boolean useSetStringForClobs = false;
    public int maxEmbeddedBlobSize = -1;
    public int maxEmbeddedClobSize = -1;
    public int inClauseLimit = -1;
    public int datePrecision = 1000000;
    public int characterColumnSize = 255;
    public String arrayTypeName = "ARRAY";
    public String bigintTypeName = "BIGINT";
    public String binaryTypeName = "BINARY";
    public String bitTypeName = "BIT";
    public String blobTypeName = "BLOB";
    public String booleanTypeName = "BOOLEAN";
    public String charTypeName = "CHAR";
    public String clobTypeName = "CLOB";
    public String dateTypeName = "DATE";
    public String decimalTypeName = "DECIMAL";
    public String distinctTypeName = "DISTINCT";
    public String doubleTypeName = "DOUBLE";
    public String floatTypeName = "FLOAT";
    public String integerTypeName = "INTEGER";
    public String javaObjectTypeName = "JAVA_OBJECT";
    public String longVarbinaryTypeName = "LONGVARBINARY";
    public String longVarcharTypeName = "LONGVARCHAR";
    public String nullTypeName = "NULL";
    public String numericTypeName = "NUMERIC";
    public String otherTypeName = "OTHER";
    public String realTypeName = "REAL";
    public String refTypeName = "REF";
    public String smallintTypeName = "SMALLINT";
    public String structTypeName = "STRUCT";
    public String timeTypeName = "TIME";
    public String timestampTypeName = "TIMESTAMP";
    public String tinyintTypeName = "TINYINT";
    public String varbinaryTypeName = "VARBINARY";
    public String varcharTypeName = "VARCHAR";
    public boolean useSchemaName = true;
    public String tableTypes = "TABLE";
    public boolean supportsSchemaForGetTables = true;
    public boolean supportsSchemaForGetColumns = true;
    public boolean supportsNullTableForGetColumns = true;
    public boolean supportsNullTableForGetPrimaryKeys = false;
    public boolean supportsNullTableForGetIndexInfo = false;
    public boolean supportsNullTableForGetImportedKeys = false;
    public boolean useGetBestRowIdentifierForPrimaryKeys = false;
    public boolean requiresAutoCommitForMetaData = false;
    public int maxAutoAssignNameLength = 31;
    public String autoAssignClause = null;
    public String autoAssignTypeName = null;
    public boolean supportsAutoAssign = false;
    public String lastGeneratedKeyQuery = null;
    public String nextSequenceQuery = null;
    public String sequenceSQL = null;
    public String sequenceSchemaSQL = null;
    public String sequenceNameSQL = null;
    protected JDBCConfiguration conf = null;
    protected Log log = null;
    protected boolean connected = false;
    protected final Set reservedWordSet = new HashSet();
    protected final Set systemSchemaSet = new HashSet();
    protected final Set systemTableSet = new HashSet();
    protected final Set fixedSizeTypeNameSet = new HashSet();
    private Set _precisionWarnedTypes = null;
    private Method _setBytes = null;
    private Method _setString = null;
    private Method _setCharStream = null;

    public DBDictionary() {
        this.fixedSizeTypeNameSet.addAll(Arrays.asList("BIGINT", "BIT", "BLOB", "CLOB", "DATE", "DECIMAL", "DISTINCT", "DOUBLE", "FLOAT", "INTEGER", "JAVA_OBJECT", "NULL", "NUMERIC", "OTHER", "REAL", "REF", "SMALLINT", "STRUCT", "TIME", "TIMESTAMP", "TINYINT"));
    }

    public void connectedConfiguration(Connection conn) throws SQLException {
        if (!this.connected) {
            try {
                if (this.log.isTraceEnabled()) {
                    this.log.trace(DBDictionaryFactory.toString(conn.getMetaData()));
                }
            }
            catch (Exception e) {
                this.log.trace(e.toString(), e);
            }
        }
        this.connected = true;
    }

    public Array getArray(ResultSet rs, int column) throws SQLException {
        return rs.getArray(column);
    }

    public InputStream getAsciiStream(ResultSet rs, int column) throws SQLException {
        return rs.getAsciiStream(column);
    }

    public BigDecimal getBigDecimal(ResultSet rs, int column) throws SQLException {
        if (this.storeLargeNumbersAsStrings) {
            String str = this.getString(rs, column);
            return str == null ? null : new BigDecimal(str);
        }
        return rs.getBigDecimal(column);
    }

    public Number getNumber(ResultSet rs, int column) throws SQLException {
        try {
            return this.getBigDecimal(rs, column);
        }
        catch (Exception e1) {
            try {
                return new Double(this.getDouble(rs, column));
            }
            catch (Exception e2) {
                try {
                    return new Float(this.getFloat(rs, column));
                }
                catch (Exception e3) {
                    try {
                        return Numbers.valueOf((long)this.getLong(rs, column));
                    }
                    catch (Exception e4) {
                        try {
                            return Numbers.valueOf((int)this.getInt(rs, column));
                        }
                        catch (Exception e5) {
                            if (e1 instanceof RuntimeException) {
                                throw (RuntimeException)e1;
                            }
                            if (e1 instanceof SQLException) {
                                throw (SQLException)e1;
                            }
                            return null;
                        }
                    }
                }
            }
        }
    }

    public BigInteger getBigInteger(ResultSet rs, int column) throws SQLException {
        if (this.storeLargeNumbersAsStrings) {
            String str = this.getString(rs, column);
            return str == null ? null : new BigDecimal(str).toBigInteger();
        }
        BigDecimal bd = this.getBigDecimal(rs, column);
        return bd == null ? null : bd.toBigInteger();
    }

    public InputStream getBinaryStream(ResultSet rs, int column) throws SQLException {
        return rs.getBinaryStream(column);
    }

    public Blob getBlob(ResultSet rs, int column) throws SQLException {
        return rs.getBlob(column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getBlobObject(ResultSet rs, int column, JDBCStore store) throws SQLException {
        Object object;
        InputStream in = null;
        if (this.useGetBytesForBlobs || this.useGetObjectForBlobs) {
            byte[] bytes = this.getBytes(rs, column);
            if (bytes != null && bytes.length > 0) {
                in = new ByteArrayInputStream(bytes);
            }
        } else {
            Blob blob = this.getBlob(rs, column);
            if (blob != null && blob.length() > 0L) {
                in = blob.getBinaryStream();
            }
        }
        if (in == null) {
            return null;
        }
        if (store == null) {
            object = Serialization.deserialize(in, null);
            return object;
        }
        object = Serialization.deserialize(in, store.getContext());
        return object;
        finally {
            try {
                in.close();
            }
            catch (IOException ioe) {}
        }
    }

    public boolean getBoolean(ResultSet rs, int column) throws SQLException {
        return rs.getBoolean(column);
    }

    public byte getByte(ResultSet rs, int column) throws SQLException {
        return rs.getByte(column);
    }

    public byte[] getBytes(ResultSet rs, int column) throws SQLException {
        if (this.useGetBytesForBlobs) {
            return rs.getBytes(column);
        }
        if (this.useGetObjectForBlobs) {
            return (byte[])rs.getObject(column);
        }
        Blob blob = this.getBlob(rs, column);
        if (blob == null) {
            return null;
        }
        int length = (int)blob.length();
        if (length == 0) {
            return null;
        }
        return blob.getBytes(1L, length);
    }

    public Calendar getCalendar(ResultSet rs, int column) throws SQLException {
        Date d = this.getDate(rs, column);
        if (d == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal;
    }

    public char getChar(ResultSet rs, int column) throws SQLException {
        if (this.storeCharsAsNumbers) {
            return (char)this.getInt(rs, column);
        }
        String str = this.getString(rs, column);
        return StringUtils.isEmpty((String)str) ? (char)'\u0000' : str.charAt(0);
    }

    public Reader getCharacterStream(ResultSet rs, int column) throws SQLException {
        return rs.getCharacterStream(column);
    }

    public Clob getClob(ResultSet rs, int column) throws SQLException {
        return rs.getClob(column);
    }

    public String getClobString(ResultSet rs, int column) throws SQLException {
        if (this.useGetStringForClobs) {
            return rs.getString(column);
        }
        Clob clob = this.getClob(rs, column);
        if (clob == null) {
            return null;
        }
        if (clob.length() == 0L) {
            return "";
        }
        return clob.getSubString(1L, (int)clob.length());
    }

    public Date getDate(ResultSet rs, int column) throws SQLException {
        Timestamp tstamp = this.getTimestamp(rs, column, null);
        if (tstamp == null) {
            return null;
        }
        int fractional = (int)Math.round((double)tstamp.getNanos() / 1000000.0);
        long millis = tstamp.getTime() / 1000L * 1000L;
        return new Date(millis + (long)fractional);
    }

    public java.sql.Date getDate(ResultSet rs, int column, Calendar cal) throws SQLException {
        if (cal == null) {
            return rs.getDate(column);
        }
        return rs.getDate(column, cal);
    }

    public double getDouble(ResultSet rs, int column) throws SQLException {
        return rs.getDouble(column);
    }

    public float getFloat(ResultSet rs, int column) throws SQLException {
        return rs.getFloat(column);
    }

    public int getInt(ResultSet rs, int column) throws SQLException {
        return rs.getInt(column);
    }

    public Locale getLocale(ResultSet rs, int column) throws SQLException {
        String str = this.getString(rs, column);
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        String[] params = Strings.split((String)str, (String)"_", (int)3);
        if (params.length < 3) {
            return null;
        }
        return new Locale(params[0], params[1], params[2]);
    }

    public long getLong(ResultSet rs, int column) throws SQLException {
        return rs.getLong(column);
    }

    public Object getObject(ResultSet rs, int column, Map map) throws SQLException {
        if (map == null) {
            return rs.getObject(column);
        }
        return rs.getObject(column, map);
    }

    public Ref getRef(ResultSet rs, int column, Map map) throws SQLException {
        return rs.getRef(column);
    }

    public short getShort(ResultSet rs, int column) throws SQLException {
        return rs.getShort(column);
    }

    public String getString(ResultSet rs, int column) throws SQLException {
        return rs.getString(column);
    }

    public Time getTime(ResultSet rs, int column, Calendar cal) throws SQLException {
        if (cal == null) {
            return rs.getTime(column);
        }
        return rs.getTime(column, cal);
    }

    public Timestamp getTimestamp(ResultSet rs, int column, Calendar cal) throws SQLException {
        if (cal == null) {
            return rs.getTimestamp(column);
        }
        return rs.getTimestamp(column, cal);
    }

    public void setArray(PreparedStatement stmnt, int idx, Array val, Column col) throws SQLException {
        stmnt.setArray(idx, val);
    }

    public void setAsciiStream(PreparedStatement stmnt, int idx, InputStream val, int length, Column col) throws SQLException {
        stmnt.setAsciiStream(idx, val, length);
    }

    public void setBigDecimal(PreparedStatement stmnt, int idx, BigDecimal val, Column col) throws SQLException {
        if (col != null && col.isCompatible(12, null, 0, 0) || col == null && this.storeLargeNumbersAsStrings) {
            this.setString(stmnt, idx, val.toString(), col);
        } else {
            stmnt.setBigDecimal(idx, val);
        }
    }

    public void setBigInteger(PreparedStatement stmnt, int idx, BigInteger val, Column col) throws SQLException {
        if (col != null && col.isCompatible(12, null, 0, 0) || col == null && this.storeLargeNumbersAsStrings) {
            this.setString(stmnt, idx, val.toString(), col);
        } else {
            this.setBigDecimal(stmnt, idx, new BigDecimal(val), col);
        }
    }

    public void setBinaryStream(PreparedStatement stmnt, int idx, InputStream val, int length, Column col) throws SQLException {
        stmnt.setBinaryStream(idx, val, length);
    }

    public void setBlob(PreparedStatement stmnt, int idx, Blob val, Column col) throws SQLException {
        stmnt.setBlob(idx, val);
    }

    public void setBlobObject(PreparedStatement stmnt, int idx, Object val, Column col, JDBCStore store) throws SQLException {
        this.setBytes(stmnt, idx, this.serialize(val, store), col);
    }

    public void setBoolean(PreparedStatement stmnt, int idx, boolean val, Column col) throws SQLException {
        stmnt.setInt(idx, val ? 1 : 0);
    }

    public void setByte(PreparedStatement stmnt, int idx, byte val, Column col) throws SQLException {
        stmnt.setByte(idx, val);
    }

    public void setBytes(PreparedStatement stmnt, int idx, byte[] val, Column col) throws SQLException {
        if (this.useSetBytesForBlobs) {
            stmnt.setBytes(idx, val);
        } else {
            this.setBinaryStream(stmnt, idx, new ByteArrayInputStream(val), val.length, col);
        }
    }

    public void setChar(PreparedStatement stmnt, int idx, char val, Column col) throws SQLException {
        if (col != null && col.isCompatible(4, null, 0, 0) || col == null && this.storeCharsAsNumbers) {
            this.setInt(stmnt, idx, val, col);
        } else {
            this.setString(stmnt, idx, String.valueOf(val), col);
        }
    }

    public void setCharacterStream(PreparedStatement stmnt, int idx, Reader val, int length, Column col) throws SQLException {
        stmnt.setCharacterStream(idx, val, length);
    }

    public void setClob(PreparedStatement stmnt, int idx, Clob val, Column col) throws SQLException {
        stmnt.setClob(idx, val);
    }

    public void setClobString(PreparedStatement stmnt, int idx, String val, Column col) throws SQLException {
        if (this.useSetStringForClobs) {
            stmnt.setString(idx, val);
        } else {
            StringReader in = new StringReader(val);
            this.setCharacterStream(stmnt, idx, in, val.length(), col);
        }
    }

    public void setDate(PreparedStatement stmnt, int idx, Date val, Column col) throws SQLException {
        if (col != null && col.getType() == 91) {
            this.setDate(stmnt, idx, new java.sql.Date(val.getTime()), null, col);
        } else if (col != null && col.getType() == 92) {
            this.setTime(stmnt, idx, new Time(val.getTime()), null, col);
        } else {
            this.setTimestamp(stmnt, idx, new Timestamp(val.getTime()), null, col);
        }
    }

    public void setDate(PreparedStatement stmnt, int idx, java.sql.Date val, Calendar cal, Column col) throws SQLException {
        if (cal == null) {
            stmnt.setDate(idx, val);
        } else {
            stmnt.setDate(idx, val, cal);
        }
    }

    public void setCalendar(PreparedStatement stmnt, int idx, Calendar val, Column col) throws SQLException {
        this.setDate(stmnt, idx, val.getTime(), col);
    }

    public void setDouble(PreparedStatement stmnt, int idx, double val, Column col) throws SQLException {
        stmnt.setDouble(idx, val);
    }

    public void setFloat(PreparedStatement stmnt, int idx, float val, Column col) throws SQLException {
        stmnt.setFloat(idx, val);
    }

    public void setInt(PreparedStatement stmnt, int idx, int val, Column col) throws SQLException {
        stmnt.setInt(idx, val);
    }

    public void setLong(PreparedStatement stmnt, int idx, long val, Column col) throws SQLException {
        stmnt.setLong(idx, val);
    }

    public void setLocale(PreparedStatement stmnt, int idx, Locale val, Column col) throws SQLException {
        this.setString(stmnt, idx, val.getLanguage() + "_" + val.getCountry() + "_" + val.getVariant(), col);
    }

    public void setNull(PreparedStatement stmnt, int idx, int colType, Column col) throws SQLException {
        stmnt.setNull(idx, colType);
    }

    public void setNumber(PreparedStatement stmnt, int idx, Number num, Column col) throws SQLException {
        if (num instanceof Double) {
            this.setDouble(stmnt, idx, (Double)num, col);
        } else if (num instanceof Float) {
            this.setFloat(stmnt, idx, ((Float)num).floatValue(), col);
        } else {
            this.setBigDecimal(stmnt, idx, new BigDecimal(num.toString()), col);
        }
    }

    public void setObject(PreparedStatement stmnt, int idx, Object val, int colType, Column col) throws SQLException {
        if (colType == -1 || colType == 1111) {
            stmnt.setObject(idx, val);
        } else {
            stmnt.setObject(idx, val, colType);
        }
    }

    public void setRef(PreparedStatement stmnt, int idx, Ref val, Column col) throws SQLException {
        stmnt.setRef(idx, val);
    }

    public void setShort(PreparedStatement stmnt, int idx, short val, Column col) throws SQLException {
        stmnt.setShort(idx, val);
    }

    public void setString(PreparedStatement stmnt, int idx, String val, Column col) throws SQLException {
        stmnt.setString(idx, val);
    }

    public void setTime(PreparedStatement stmnt, int idx, Time val, Calendar cal, Column col) throws SQLException {
        if (cal == null) {
            stmnt.setTime(idx, val);
        } else {
            stmnt.setTime(idx, val, cal);
        }
    }

    public void setTimestamp(PreparedStatement stmnt, int idx, Timestamp val, Calendar cal, Column col) throws SQLException {
        int rounded = (int)Math.round((double)val.getNanos() / (double)this.datePrecision);
        int nanos = rounded * this.datePrecision;
        if (nanos > 999999999) {
            val.setTime(val.getTime() + 1000L);
            nanos = 0;
        }
        if (this.supportsTimestampNanos) {
            val.setNanos(nanos);
        } else {
            val.setNanos(0);
        }
        if (cal == null) {
            stmnt.setTimestamp(idx, val);
        } else {
            stmnt.setTimestamp(idx, val, cal);
        }
    }

    public void setTyped(PreparedStatement stmnt, int idx, Object val, Column col, int type, JDBCStore store) throws SQLException {
        if (val == null) {
            this.setNull(stmnt, idx, col == null ? 1111 : col.getType(), col);
            return;
        }
        switch (type) {
            case 0: 
            case 16: {
                this.setBoolean(stmnt, idx, (Boolean)val, col);
                break;
            }
            case 1: 
            case 17: {
                this.setByte(stmnt, idx, ((Number)val).byteValue(), col);
                break;
            }
            case 2: 
            case 18: {
                this.setChar(stmnt, idx, ((Character)val).charValue(), col);
                break;
            }
            case 3: 
            case 19: {
                this.setDouble(stmnt, idx, ((Number)val).doubleValue(), col);
                break;
            }
            case 4: 
            case 20: {
                this.setFloat(stmnt, idx, ((Number)val).floatValue(), col);
                break;
            }
            case 5: 
            case 21: {
                this.setInt(stmnt, idx, ((Number)val).intValue(), col);
                break;
            }
            case 6: 
            case 22: {
                this.setLong(stmnt, idx, ((Number)val).longValue(), col);
                break;
            }
            case 7: 
            case 23: {
                this.setShort(stmnt, idx, ((Number)val).shortValue(), col);
                break;
            }
            case 9: {
                if (col != null && (col.getType() == 2005 || col.getType() == -1)) {
                    this.setClobString(stmnt, idx, (String)val, col);
                    break;
                }
                this.setString(stmnt, idx, (String)val, col);
                break;
            }
            case 8: {
                this.setBlobObject(stmnt, idx, val, col, store);
                break;
            }
            case 14: {
                this.setDate(stmnt, idx, (Date)val, col);
                break;
            }
            case 28: {
                this.setCalendar(stmnt, idx, (Calendar)val, col);
                break;
            }
            case 24: {
                this.setBigDecimal(stmnt, idx, (BigDecimal)val, col);
                break;
            }
            case 25: {
                this.setBigInteger(stmnt, idx, (BigInteger)val, col);
                break;
            }
            case 10: {
                this.setNumber(stmnt, idx, (Number)val, col);
                break;
            }
            case 26: {
                this.setLocale(stmnt, idx, (Locale)val, col);
                break;
            }
            case 1000: {
                this.setArray(stmnt, idx, (Array)val, col);
                break;
            }
            case 1001: {
                Sized s = (Sized)val;
                this.setAsciiStream(stmnt, idx, (InputStream)s.value, s.size, col);
                break;
            }
            case 1002: {
                Sized s = (Sized)val;
                this.setBinaryStream(stmnt, idx, (InputStream)s.value, s.size, col);
                break;
            }
            case 1003: {
                this.setBlob(stmnt, idx, (Blob)val, col);
                break;
            }
            case 1004: {
                this.setBytes(stmnt, idx, (byte[])val, col);
                break;
            }
            case 1005: {
                Sized s = (Sized)val;
                this.setCharacterStream(stmnt, idx, (Reader)s.value, s.size, col);
                break;
            }
            case 1006: {
                this.setClob(stmnt, idx, (Clob)val, col);
                break;
            }
            case 1007: {
                if (val instanceof Calendard) {
                    Calendard c = (Calendard)val;
                    this.setDate(stmnt, idx, (java.sql.Date)c.value, c.calendar, col);
                    break;
                }
                this.setDate(stmnt, idx, (java.sql.Date)val, null, col);
                break;
            }
            case 1009: {
                this.setRef(stmnt, idx, (Ref)val, col);
                break;
            }
            case 1010: {
                if (val instanceof Calendard) {
                    Calendard c = (Calendard)val;
                    this.setTime(stmnt, idx, (Time)c.value, c.calendar, col);
                    break;
                }
                this.setTime(stmnt, idx, (Time)val, null, col);
                break;
            }
            case 1011: {
                if (val instanceof Calendard) {
                    Calendard c = (Calendard)val;
                    this.setTimestamp(stmnt, idx, (Timestamp)c.value, c.calendar, col);
                    break;
                }
                this.setTimestamp(stmnt, idx, (Timestamp)val, null, col);
                break;
            }
            default: {
                if (col != null && (col.getType() == 2004 || col.getType() == -3)) {
                    this.setBlobObject(stmnt, idx, val, col, store);
                    break;
                }
                this.setObject(stmnt, idx, val, col.getType(), col);
            }
        }
    }

    public void setUnknown(PreparedStatement stmnt, int idx, Object val, Column col) throws SQLException {
        Sized sized = null;
        Calendard cald = null;
        if (val instanceof Sized) {
            sized = (Sized)val;
            val = sized.value;
        } else if (val instanceof Calendard) {
            cald = (Calendard)val;
            val = cald.value;
        }
        if (val == null) {
            this.setNull(stmnt, idx, col == null ? 1111 : col.getType(), col);
        } else if (val instanceof String) {
            this.setString(stmnt, idx, val.toString(), col);
        } else if (val instanceof Integer) {
            this.setInt(stmnt, idx, (Integer)val, col);
        } else if (val instanceof Boolean) {
            this.setBoolean(stmnt, idx, (Boolean)val, col);
        } else if (val instanceof Long) {
            this.setLong(stmnt, idx, (Long)val, col);
        } else if (val instanceof Float) {
            this.setFloat(stmnt, idx, ((Float)val).floatValue(), col);
        } else if (val instanceof Double) {
            this.setDouble(stmnt, idx, (Double)val, col);
        } else if (val instanceof Byte) {
            this.setByte(stmnt, idx, (Byte)val, col);
        } else if (val instanceof Character) {
            this.setChar(stmnt, idx, ((Character)val).charValue(), col);
        } else if (val instanceof Short) {
            this.setShort(stmnt, idx, (Short)val, col);
        } else if (val instanceof Locale) {
            this.setLocale(stmnt, idx, (Locale)val, col);
        } else if (val instanceof BigDecimal) {
            this.setBigDecimal(stmnt, idx, (BigDecimal)val, col);
        } else if (val instanceof BigInteger) {
            this.setBigInteger(stmnt, idx, (BigInteger)val, col);
        } else if (val instanceof Array) {
            this.setArray(stmnt, idx, (Array)val, col);
        } else if (val instanceof Blob) {
            this.setBlob(stmnt, idx, (Blob)val, col);
        } else if (val instanceof byte[]) {
            this.setBytes(stmnt, idx, (byte[])val, col);
        } else if (val instanceof Clob) {
            this.setClob(stmnt, idx, (Clob)val, col);
        } else if (val instanceof Ref) {
            this.setRef(stmnt, idx, (Ref)val, col);
        } else if (val instanceof java.sql.Date) {
            this.setDate(stmnt, idx, (java.sql.Date)val, cald == null ? null : cald.calendar, col);
        } else if (val instanceof Timestamp) {
            this.setTimestamp(stmnt, idx, (Timestamp)val, cald == null ? null : cald.calendar, col);
        } else if (val instanceof Time) {
            this.setTime(stmnt, idx, (Time)val, cald == null ? null : cald.calendar, col);
        } else if (val instanceof Date) {
            this.setDate(stmnt, idx, (Date)val, col);
        } else if (val instanceof Calendar) {
            this.setDate(stmnt, idx, ((Calendar)val).getTime(), col);
        } else if (val instanceof Reader) {
            this.setCharacterStream(stmnt, idx, (Reader)val, sized == null ? 0 : sized.size, col);
        } else {
            throw new UserException(_loc.get("bad-param", val.getClass()));
        }
    }

    public byte[] serialize(Object val, JDBCStore store) throws SQLException {
        if (val == null) {
            return null;
        }
        if (val instanceof SerializedData) {
            return ((SerializedData)val).bytes;
        }
        return Serialization.serialize(val, store.getContext());
    }

    public void putBytes(Object blob, byte[] data) throws SQLException {
        if (this._setBytes == null) {
            try {
                this._setBytes = blob.getClass().getMethod("setBytes", Long.TYPE, [B.class);
            }
            catch (Exception e) {
                throw new StoreException(e);
            }
        }
        DBDictionary.invokePutLobMethod(this._setBytes, blob, new Object[]{Numbers.valueOf((long)1L), data});
    }

    public void putString(Object clob, String data) throws SQLException {
        if (this._setString == null) {
            try {
                this._setString = clob.getClass().getMethod("setString", Long.TYPE, String.class);
            }
            catch (Exception e) {
                throw new StoreException(e);
            }
        }
        DBDictionary.invokePutLobMethod(this._setString, clob, new Object[]{Numbers.valueOf((long)1L), data});
    }

    public void putChars(Object clob, char[] data) throws SQLException {
        if (this._setCharStream == null) {
            try {
                this._setCharStream = clob.getClass().getMethod("setCharacterStream", Long.TYPE);
            }
            catch (Exception e) {
                throw new StoreException(e);
            }
        }
        Writer writer = (Writer)DBDictionary.invokePutLobMethod(this._setCharStream, clob, new Object[]{Numbers.valueOf((long)1L)});
        try {
            writer.write(data);
            writer.flush();
        }
        catch (IOException ioe) {
            throw new SQLException(ioe.toString());
        }
    }

    private static Object invokePutLobMethod(Method method, Object target, Object[] args) throws SQLException {
        try {
            return method.invoke(target, args);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof SQLException) {
                throw (SQLException)t;
            }
            throw new StoreException(t);
        }
        catch (Exception e) {
            throw new StoreException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storageWarning(Object orig, Object converted) {
        boolean warn;
        DBDictionary dBDictionary = this;
        synchronized (dBDictionary) {
            if (this._precisionWarnedTypes == null) {
                this._precisionWarnedTypes = new HashSet();
            }
            warn = this._precisionWarnedTypes.add(orig.getClass());
        }
        if (this.storageLimitationsFatal || warn && this.log.isWarnEnabled() || !warn && this.log.isTraceEnabled()) {
            Localizer.Message msg = _loc.get("storage-restriction", new Object[]{this.platform, orig, orig.getClass().getName(), converted});
            if (this.storageLimitationsFatal) {
                throw new StoreException(msg);
            }
            if (warn) {
                this.log.warn(msg);
            } else {
                this.log.trace(msg);
            }
        }
    }

    public int getJDBCType(int metaTypeCode, boolean lob) {
        if (lob) {
            switch (metaTypeCode) {
                case 9: 
                case 1001: 
                case 1005: {
                    return this.getPreferredType(2005);
                }
            }
            return this.getPreferredType(2004);
        }
        switch (metaTypeCode) {
            case 0: 
            case 16: {
                return this.getPreferredType(-7);
            }
            case 1: 
            case 17: {
                return this.getPreferredType(-6);
            }
            case 2: 
            case 18: {
                if (this.storeCharsAsNumbers) {
                    return this.getPreferredType(4);
                }
                return this.getPreferredType(1);
            }
            case 3: 
            case 19: {
                return this.getPreferredType(8);
            }
            case 4: 
            case 20: {
                return this.getPreferredType(7);
            }
            case 5: 
            case 21: {
                return this.getPreferredType(4);
            }
            case 6: 
            case 22: {
                return this.getPreferredType(-5);
            }
            case 7: 
            case 23: {
                return this.getPreferredType(5);
            }
            case 9: 
            case 26: 
            case 1001: 
            case 1005: {
                return this.getPreferredType(12);
            }
            case 25: {
                if (this.storeLargeNumbersAsStrings) {
                    return this.getPreferredType(12);
                }
                return this.getPreferredType(-5);
            }
            case 24: {
                if (this.storeLargeNumbersAsStrings) {
                    return this.getPreferredType(12);
                }
                return this.getPreferredType(8);
            }
            case 10: {
                if (this.storeLargeNumbersAsStrings) {
                    return this.getPreferredType(12);
                }
                return this.getPreferredType(2);
            }
            case 14: 
            case 28: {
                return this.getPreferredType(93);
            }
            case 1000: {
                return this.getPreferredType(2003);
            }
            case 1002: 
            case 1003: 
            case 1004: {
                return this.getPreferredType(2004);
            }
            case 1006: {
                return this.getPreferredType(2005);
            }
            case 1007: {
                return this.getPreferredType(91);
            }
            case 1010: {
                return this.getPreferredType(92);
            }
            case 1011: {
                return this.getPreferredType(93);
            }
        }
        return this.getPreferredType(2004);
    }

    public int getPreferredType(int type) {
        return type;
    }

    public String getTypeName(Column col) {
        if (!StringUtils.isEmpty((String)col.getTypeName())) {
            return this.appendSize(col, col.getTypeName());
        }
        if (col.isAutoAssigned() && this.autoAssignTypeName != null) {
            return this.appendSize(col, this.autoAssignTypeName);
        }
        return this.appendSize(col, this.getTypeName(col.getType()));
    }

    public String getTypeName(int type) {
        switch (type) {
            case 2003: {
                return this.arrayTypeName;
            }
            case -5: {
                return this.bigintTypeName;
            }
            case -2: {
                return this.binaryTypeName;
            }
            case -7: {
                return this.bitTypeName;
            }
            case 2004: {
                return this.blobTypeName;
            }
            case 16: {
                return this.booleanTypeName;
            }
            case 1: {
                return this.charTypeName;
            }
            case 2005: {
                return this.clobTypeName;
            }
            case 91: {
                return this.dateTypeName;
            }
            case 3: {
                return this.decimalTypeName;
            }
            case 2001: {
                return this.distinctTypeName;
            }
            case 8: {
                return this.doubleTypeName;
            }
            case 6: {
                return this.floatTypeName;
            }
            case 4: {
                return this.integerTypeName;
            }
            case 2000: {
                return this.javaObjectTypeName;
            }
            case -4: {
                return this.longVarbinaryTypeName;
            }
            case -1: {
                return this.longVarcharTypeName;
            }
            case 0: {
                return this.nullTypeName;
            }
            case 2: {
                return this.numericTypeName;
            }
            case 1111: {
                return this.otherTypeName;
            }
            case 7: {
                return this.realTypeName;
            }
            case 2006: {
                return this.refTypeName;
            }
            case 5: {
                return this.smallintTypeName;
            }
            case 2002: {
                return this.structTypeName;
            }
            case 92: {
                return this.timeTypeName;
            }
            case 93: {
                return this.timestampTypeName;
            }
            case -6: {
                return this.tinyintTypeName;
            }
            case -3: {
                return this.varbinaryTypeName;
            }
            case 12: {
                return this.varcharTypeName;
            }
        }
        return this.otherTypeName;
    }

    protected String appendSize(Column col, String typeName) {
        int idx;
        if (this.fixedSizeTypeNameSet.contains(typeName.toUpperCase())) {
            return typeName;
        }
        if (typeName.indexOf(40) != -1) {
            return typeName;
        }
        String size = null;
        if (col.getSize() > 0) {
            StringBuffer buf = new StringBuffer(10);
            buf.append("(").append(col.getSize());
            if (col.getDecimalDigits() > 0) {
                buf.append(", ").append(col.getDecimalDigits());
            }
            buf.append(")");
            size = buf.toString();
        }
        if ((idx = typeName.indexOf("{0}")) == -1 && size != null) {
            return typeName + size;
        }
        if (idx == -1) {
            return typeName;
        }
        String ret = typeName.substring(0, idx);
        if (size != null) {
            ret = ret + size;
        }
        if (typeName.length() > idx + 3) {
            ret = ret + typeName.substring(idx + 3);
        }
        return ret;
    }

    public void setJoinSyntax(String syntax) {
        if ("sql92".equals(syntax)) {
            this.joinSyntax = 0;
        } else if ("traditional".equals(syntax)) {
            this.joinSyntax = 1;
        } else if ("database".equals(syntax)) {
            this.joinSyntax = 2;
        } else if (!StringUtils.isEmpty((String)syntax)) {
            throw new IllegalArgumentException(syntax);
        }
    }

    public String getPlaceholderValueString(Column col) {
        switch (col.getType()) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 4: 
            case 5: {
                return "0";
            }
            case 1: {
                return this.storeCharsAsNumbers ? "0" : "' '";
            }
            case -1: 
            case 12: 
            case 2005: {
                return "''";
            }
            case 91: {
                return ZERO_DATE_STR;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return "0.0";
            }
            case 92: {
                return ZERO_TIME_STR;
            }
            case 93: {
                return ZERO_TIMESTAMP_STR;
            }
        }
        return "NULL";
    }

    public SQLBuffer toSelectCount(Select sel) {
        SQLBuffer selectSQL = new SQLBuffer(this);
        sel.addJoinClassConditions();
        SQLBuffer from = sel.getFromSelect() != null ? this.getFromSelect(sel, false) : this.getFrom(sel, false);
        SQLBuffer where = this.getWhere(sel, false);
        if (sel.getGrouping() == null && sel.getStartIndex() == 0L && sel.getEndIndex() == Long.MAX_VALUE) {
            List aliases;
            List list = aliases = !sel.isDistinct() ? Collections.EMPTY_LIST : sel.getIdentifierAliases();
            if (aliases.isEmpty()) {
                selectSQL.append("COUNT(*)");
                return this.toSelect(selectSQL, null, from, where, null, null, null, false, false, 0L, Long.MAX_VALUE);
            }
            if (aliases.size() == 1) {
                selectSQL.append("COUNT(DISTINCT ").append(aliases.get(0).toString()).append(")");
                return this.toSelect(selectSQL, null, from, where, null, null, null, false, false, 0L, Long.MAX_VALUE);
            }
            if (this.distinctCountColumnSeparator != null) {
                selectSQL.append("COUNT(DISTINCT ");
                for (int i = 0; i < aliases.size(); ++i) {
                    if (i > 0) {
                        selectSQL.append(" ");
                        selectSQL.append(this.distinctCountColumnSeparator);
                        selectSQL.append(" ");
                    }
                    selectSQL.append(aliases.get(i).toString());
                }
                selectSQL.append(")");
                return this.toSelect(selectSQL, null, from, where, null, null, null, false, false, 0L, Long.MAX_VALUE);
            }
        }
        this.assertSupport(this.supportsSubselect, "SupportsSubselect");
        SQLBuffer subSelect = this.getSelects(sel, true, false);
        SQLBuffer subFrom = from;
        from = new SQLBuffer(this);
        from.append("(");
        from.append(this.toSelect(subSelect, null, subFrom, where, sel.getGrouping(), sel.getHaving(), null, sel.isDistinct(), false, sel.getStartIndex(), sel.getEndIndex()));
        from.append(")");
        if (this.requiresAliasForSubselect) {
            from.append(" ").append("s");
        }
        selectSQL.append("COUNT(*)");
        return this.toSelect(selectSQL, null, from, null, null, null, null, false, false, 0L, Long.MAX_VALUE);
    }

    public SQLBuffer toDelete(ClassMapping mapping, Select sel, Object[] params) {
        return this.toBulkOperation(mapping, sel, null, params, null);
    }

    public SQLBuffer toUpdate(ClassMapping mapping, Select sel, JDBCStore store, Object[] params, Map updates) {
        return this.toBulkOperation(mapping, sel, store, params, updates);
    }

    protected SQLBuffer toBulkOperation(ClassMapping mapping, Select sel, JDBCStore store, Object[] params, Map updateParams) {
        SQLBuffer sql2 = new SQLBuffer(this);
        if (updateParams == null) {
            sql2.append("DELETE FROM ");
        } else {
            sql2.append("UPDATE ");
        }
        sel.addJoinClassConditions();
        if (sel.getTableAliases().size() == 1 && this.supportsSubselect && this.allowsAliasInBulkClause) {
            SQLBuffer from = sel.getFromSelect() != null ? this.getFromSelect(sel, false) : this.getFrom(sel, false);
            sql2.append(from);
            this.appendUpdates(sel, store, sql2, params, updateParams, this.allowsAliasInBulkClause);
            SQLBuffer where = sel.getWhere();
            if (where != null && !where.isEmpty()) {
                sql2.append(" WHERE ");
                sql2.append(where);
            }
            return sql2;
        }
        Table table = mapping.getTable();
        String tableName = this.getFullName(table, false);
        if (sel.getWhere() == null || sel.getWhere().isEmpty()) {
            sql2.append(tableName);
            this.appendUpdates(sel, store, sql2, params, updateParams, false);
            return sql2;
        }
        if (!this.supportsSubselect || !this.supportsCorrelatedSubselect) {
            return null;
        }
        Column[] pks = mapping.getPrimaryKeyColumns();
        sel.clearSelects();
        sel.setDistinct(true);
        if (pks.length == 1) {
            sel.select(pks[0]);
            sql2.append(tableName);
            this.appendUpdates(sel, store, sql2, params, updateParams, false);
            sql2.append(" WHERE ").append(pks[0]).append(" IN (").append(sel.toSelect(false, null)).append(")");
        } else {
            sel.clearSelects();
            sel.setDistinct(false);
            sel.select("1", null);
            Column[] cols = table.getPrimaryKey().getColumns();
            SQLBuffer buf = new SQLBuffer(this);
            buf.append("(");
            for (int i = 0; i < cols.length; ++i) {
                if (i > 0) {
                    buf.append(" AND ");
                }
                buf.append(sel.getColumnAlias(cols[i], null)).append(" = ").append(table).append(this.catalogSeparator).append(cols[i]);
            }
            buf.append(")");
            sel.where(buf, null);
            sql2.append(tableName);
            this.appendUpdates(sel, store, sql2, params, updateParams, false);
            sql2.append(" WHERE EXISTS (").append(sel.toSelect(false, null)).append(")");
        }
        return sql2;
    }

    protected void appendUpdates(Select sel, JDBCStore store, SQLBuffer sql2, Object[] params, Map updateParams, boolean allowAlias) {
        if (updateParams == null || updateParams.size() == 0) {
            return;
        }
        sql2.append(" SET ");
        ExpContext ctx = new ExpContext(store, params, store.getFetchConfiguration());
        Iterator i = updateParams.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry next = i.next();
            FieldMetaData fmd = (FieldMetaData)next.getKey();
            Val val = (Val)next.getValue();
            Column col = ((FieldMapping)fmd).getColumns()[0];
            sql2.append(col.getName());
            sql2.append(" = ");
            ExpState state = val.initialize(sel, ctx, 0);
            val.calculateValue(sel, ctx, state, null, null);
            int length = val.length(sel, ctx, state);
            for (int j = 0; j < length; ++j) {
                val.appendTo(allowAlias ? sel : null, ctx, state, sql2, j);
            }
            if (!i.hasNext()) continue;
            sql2.append(", ");
        }
    }

    public String[] getDeleteTableContentsSQL(Table[] tables) {
        ArrayList<String> sql2 = new ArrayList<String>();
        ArrayList<String> deleteSQL = new ArrayList<String>(tables.length);
        LinkedHashSet<ForeignKey> restrictConstraints = new LinkedHashSet<ForeignKey>();
        for (int i = 0; i < tables.length; ++i) {
            ForeignKey[] fks = tables[i].getForeignKeys();
            for (int j = 0; j < fks.length; ++j) {
                if (!fks[j].isLogical() && !fks[j].isDeferred() && fks[j].getDeleteAction() == 2) {
                    restrictConstraints.add(fks[j]);
                }
                String[] constraintSQL = this.getDropForeignKeySQL(fks[j]);
                sql2.addAll(Arrays.asList(constraintSQL));
            }
            deleteSQL.add("DELETE FROM " + tables[i].getFullName());
        }
        sql2.addAll(deleteSQL);
        Iterator iter = restrictConstraints.iterator();
        while (iter.hasNext()) {
            String[] constraintSQL = this.getAddForeignKeySQL((ForeignKey)iter.next());
            sql2.addAll(Arrays.asList(constraintSQL));
        }
        return sql2.toArray(new String[sql2.size()]);
    }

    public SQLBuffer toSelect(Select sel, boolean forUpdate, JDBCFetchConfiguration fetch) {
        sel.addJoinClassConditions();
        boolean update = forUpdate && sel.getFromSelect() == null;
        SQLBuffer select = this.getSelects(sel, false, update);
        SQLBuffer ordering = null;
        if (!sel.isAggregate() || sel.getGrouping() != null) {
            ordering = sel.getOrdering();
        }
        SQLBuffer from = sel.getFromSelect() != null ? this.getFromSelect(sel, forUpdate) : this.getFrom(sel, update);
        SQLBuffer where = this.getWhere(sel, update);
        return this.toSelect(select, fetch, from, where, sel.getGrouping(), sel.getHaving(), ordering, sel.isDistinct(), forUpdate, sel.getStartIndex(), sel.getEndIndex());
    }

    protected SQLBuffer getFrom(Select sel, boolean forUpdate) {
        SQLBuffer fromSQL = new SQLBuffer(this);
        Collection aliases = sel.getTableAliases();
        if (aliases.size() < 2 || sel.getJoinSyntax() != 0) {
            Iterator itr = aliases.iterator();
            while (itr.hasNext()) {
                fromSQL.append(itr.next().toString());
                if (forUpdate && this.tableForUpdateClause != null) {
                    fromSQL.append(" ").append(this.tableForUpdateClause);
                }
                if (!itr.hasNext()) continue;
                fromSQL.append(", ");
            }
        } else {
            Iterator itr = sel.getJoinIterator();
            boolean first = true;
            while (itr.hasNext()) {
                fromSQL.append(this.toSQL92Join((Join)itr.next(), forUpdate, first));
                first = false;
            }
        }
        return fromSQL;
    }

    protected SQLBuffer getFromSelect(Select sel, boolean forUpdate) {
        SQLBuffer fromSQL = new SQLBuffer(this);
        fromSQL.append("(");
        fromSQL.append(this.toSelect(sel.getFromSelect(), forUpdate, null));
        fromSQL.append(")");
        if (this.requiresAliasForSubselect) {
            fromSQL.append(" ").append("s");
        }
        return fromSQL;
    }

    protected SQLBuffer getWhere(Select sel, boolean forUpdate) {
        Joins joins = sel.getJoins();
        if (sel.getJoinSyntax() == 0 || joins == null || joins.isEmpty()) {
            return sel.getWhere();
        }
        SQLBuffer where = new SQLBuffer(this);
        if (sel.getWhere() != null) {
            where.append(sel.getWhere());
        }
        if (joins != null) {
            sel.append(where, joins);
        }
        return where;
    }

    public SQLBuffer toTraditionalJoin(Join join) {
        ForeignKey fk = join.getForeignKey();
        if (fk == null) {
            return null;
        }
        boolean inverse = join.isForeignKeyInversed();
        Column[] from = inverse ? fk.getPrimaryKeyColumns() : fk.getColumns();
        Column[] to = inverse ? fk.getColumns() : fk.getPrimaryKeyColumns();
        SQLBuffer buf = new SQLBuffer(this);
        int count = 0;
        int i = 0;
        while (i < from.length) {
            if (count > 0) {
                buf.append(" AND ");
            }
            buf.append(join.getAlias1()).append(".").append(from[i]);
            buf.append(" = ");
            buf.append(join.getAlias2()).append(".").append(to[i]);
            ++i;
            ++count;
        }
        Column[] constCols = fk.getConstantColumns();
        int i2 = 0;
        while (i2 < constCols.length) {
            if (count > 0) {
                buf.append(" AND ");
            }
            if (inverse) {
                buf.appendValue(fk.getConstant(constCols[i2]), constCols[i2]);
            } else {
                buf.append(join.getAlias1()).append(".").append(constCols[i2]);
            }
            buf.append(" = ");
            if (inverse) {
                buf.append(join.getAlias2()).append(".").append(constCols[i2]);
            } else {
                buf.appendValue(fk.getConstant(constCols[i2]), constCols[i2]);
            }
            ++i2;
            ++count;
        }
        Column[] constColsPK = fk.getConstantPrimaryKeyColumns();
        int i3 = 0;
        while (i3 < constColsPK.length) {
            if (count > 0) {
                buf.append(" AND ");
            }
            if (inverse) {
                buf.append(join.getAlias1()).append(".").append(constColsPK[i3]);
            } else {
                buf.appendValue(fk.getPrimaryKeyConstant(constColsPK[i3]), constColsPK[i3]);
            }
            buf.append(" = ");
            if (inverse) {
                buf.appendValue(fk.getPrimaryKeyConstant(constColsPK[i3]), constColsPK[i3]);
            } else {
                buf.append(join.getAlias2()).append(".").append(constColsPK[i3]);
            }
            ++i3;
            ++count;
        }
        return buf;
    }

    public SQLBuffer toSQL92Join(Join join, boolean forUpdate, boolean first) {
        SQLBuffer buf = new SQLBuffer(this);
        if (first) {
            buf.append(join.getTable1()).append(" ").append(join.getAlias1());
            if (forUpdate && this.tableForUpdateClause != null) {
                buf.append(" ").append(this.tableForUpdateClause);
            }
        }
        buf.append(" ");
        if (join.getType() == 1) {
            buf.append(this.outerJoinClause);
        } else if (join.getType() == 0) {
            buf.append(this.innerJoinClause);
        } else {
            buf.append(this.crossJoinClause);
        }
        buf.append(" ");
        buf.append(join.getTable2()).append(" ").append(join.getAlias2());
        if (forUpdate && this.tableForUpdateClause != null) {
            buf.append(" ").append(this.tableForUpdateClause);
        }
        if (join.getForeignKey() != null) {
            buf.append(" ON ").append(this.toTraditionalJoin(join));
        } else if (this.requiresConditionForCrossJoin && join.getType() == 2) {
            buf.append(" ON (1 = 1)");
        }
        return buf;
    }

    public SQLBuffer toNativeJoin(Join join) {
        throw new UnsupportedException();
    }

    public boolean canOuterJoin(int syntax, ForeignKey fk) {
        return syntax != 1;
    }

    public SQLBuffer toSelect(SQLBuffer selects, JDBCFetchConfiguration fetch, SQLBuffer from, SQLBuffer where, SQLBuffer group, SQLBuffer having, SQLBuffer order, boolean distinct, boolean forUpdate, long start, long end) {
        return this.toOperation(this.getSelectOperation(fetch), selects, from, where, group, having, order, distinct, start, end, this.getForUpdateClause(fetch, forUpdate));
    }

    protected String getForUpdateClause(JDBCFetchConfiguration fetch, boolean forUpdate) {
        if (fetch != null && fetch.getIsolation() != -1) {
            throw new InvalidStateException(_loc.get("isolation-level-config-not-supported", this.getClass().getName()));
        }
        if (forUpdate && !this.simulateLocking) {
            this.assertSupport(this.supportsSelectForUpdate, "SupportsSelectForUpdate");
            return this.forUpdateClause;
        }
        return null;
    }

    public String getSelectOperation(JDBCFetchConfiguration fetch) {
        return "SELECT";
    }

    protected SQLBuffer toOperation(String op, SQLBuffer selects, SQLBuffer from, SQLBuffer where, SQLBuffer group, SQLBuffer having, SQLBuffer order, boolean distinct, long start, long end, String forUpdateClause) {
        boolean range;
        SQLBuffer buf = new SQLBuffer(this);
        buf.append(op);
        boolean bl = range = start != 0L || end != Long.MAX_VALUE;
        if (range && this.rangePosition == 1) {
            this.appendSelectRange(buf, start, end);
        }
        if (distinct) {
            buf.append(" DISTINCT");
        }
        if (range && this.rangePosition == 2) {
            this.appendSelectRange(buf, start, end);
        }
        buf.append(" ").append(selects).append(" FROM ").append(from);
        if (where != null && !where.isEmpty()) {
            buf.append(" WHERE ").append(where);
        }
        if (group != null && !group.isEmpty()) {
            buf.append(" GROUP BY ").append(group);
        }
        if (having != null && !having.isEmpty()) {
            this.assertSupport(this.supportsHaving, "SupportsHaving");
            buf.append(" HAVING ").append(having);
        }
        if (order != null && !order.isEmpty()) {
            buf.append(" ORDER BY ").append(order);
        }
        if (range && this.rangePosition == 0) {
            this.appendSelectRange(buf, start, end);
        }
        if (forUpdateClause != null) {
            buf.append(" ").append(forUpdateClause);
        }
        if (range && this.rangePosition == 3) {
            this.appendSelectRange(buf, start, end);
        }
        return buf;
    }

    protected void appendSelectRange(SQLBuffer buf, long start, long end) {
    }

    protected SQLBuffer getSelects(Select sel, boolean distinctIdentifiers, boolean forUpdate) {
        SQLBuffer selectSQL = new SQLBuffer(this);
        List aliases = distinctIdentifiers ? sel.getIdentifierAliases() : sel.getSelectAliases();
        Iterator itr = aliases.iterator();
        while (itr.hasNext()) {
            Object alias = itr.next();
            if (alias instanceof SQLBuffer) {
                selectSQL.append((SQLBuffer)alias);
            } else {
                selectSQL.append(alias.toString());
            }
            if (!itr.hasNext()) continue;
            selectSQL.append(", ");
        }
        return selectSQL;
    }

    public boolean supportsLocking(Select sel) {
        if (sel.isAggregate()) {
            return false;
        }
        if (!this.supportsSelectForUpdate) {
            return false;
        }
        if (!(this.supportsLockingWithSelectRange || sel.getStartIndex() == 0L && sel.getEndIndex() == Long.MAX_VALUE)) {
            return false;
        }
        if (sel.getFromSelect() != null) {
            sel = sel.getFromSelect();
        }
        if (!this.supportsLockingWithDistinctClause && sel.isDistinct()) {
            return false;
        }
        if (!this.supportsLockingWithMultipleTables && sel.getTableAliases().size() > 1) {
            return false;
        }
        if (!this.supportsLockingWithOrderClause && sel.getOrdering() != null) {
            return false;
        }
        if (!this.supportsLockingWithOuterJoin || !this.supportsLockingWithInnerJoin) {
            Iterator itr = sel.getJoinIterator();
            while (itr.hasNext()) {
                Join join = (Join)itr.next();
                if (!this.supportsLockingWithOuterJoin && join.getType() == 1) {
                    return false;
                }
                if (this.supportsLockingWithInnerJoin || join.getType() != 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean supportsRandomAccessResultSet(Select sel, boolean forUpdate) {
        return !sel.isAggregate();
    }

    public void assertSupport(boolean feature, String property) {
        if (!feature) {
            throw new UnsupportedException(_loc.get("feature-not-supported", this.getClass(), property));
        }
    }

    public void substring(SQLBuffer buf, FilterValue str, FilterValue start, FilterValue end) {
        buf.append(this.substringFunctionName).append("((");
        str.appendTo(buf);
        buf.append("), (");
        start.appendTo(buf);
        buf.append(" + 1)");
        if (end != null) {
            buf.append(", (");
            end.appendTo(buf);
            buf.append(" - (");
            start.appendTo(buf);
            buf.append("))");
        }
        buf.append(")");
    }

    public void indexOf(SQLBuffer buf, FilterValue str, FilterValue find, FilterValue start) {
        buf.append("(INSTR((");
        if (start != null) {
            this.substring(buf, str, start, null);
        } else {
            str.appendTo(buf);
        }
        buf.append("), (");
        find.appendTo(buf);
        buf.append(")) - 1");
        if (start != null) {
            buf.append(" + ");
            start.appendTo(buf);
        }
        buf.append(")");
    }

    public void mathFunction(SQLBuffer buf, String op, FilterValue lhs, FilterValue rhs) {
        boolean mod;
        Class c;
        boolean castlhs = false;
        boolean castrhs = false;
        Class lc = Filters.wrap(lhs.getType());
        Class rc = Filters.wrap(rhs.getType());
        int type = 0;
        if (this.requiresCastForMathFunctions && (lc != rc || lhs.isConstant() && rhs.isConstant()) && (type = this.getJDBCType(JavaTypes.getTypeCode(c = Filters.promote(lc, rc)), false)) != -3 && type != 2004) {
            castlhs = lhs.isConstant() && rhs.isConstant() || lc != c;
            boolean bl = castrhs = lhs.isConstant() && rhs.isConstant() || rc != c;
        }
        if (mod = "MOD".equals(op)) {
            if (this.supportsModOperator) {
                op = "%";
            } else {
                buf.append(op);
            }
        }
        buf.append("(");
        if (castlhs) {
            this.appendCast(buf, lhs, type);
        } else {
            lhs.appendTo(buf);
        }
        if (mod && !this.supportsModOperator) {
            buf.append(", ");
        } else {
            buf.append(" ").append(op).append(" ");
        }
        if (castrhs) {
            this.appendCast(buf, rhs, type);
        } else {
            rhs.appendTo(buf);
        }
        buf.append(")");
    }

    public void comparison(SQLBuffer buf, String op, FilterValue lhs, FilterValue rhs) {
        Class c;
        boolean castlhs = false;
        boolean castrhs = false;
        Class lc = Filters.wrap(lhs.getType());
        Class rc = Filters.wrap(rhs.getType());
        int type = 0;
        if (this.requiresCastForComparisons && (lc != rc || lhs.isConstant() && rhs.isConstant()) && (type = this.getJDBCType(JavaTypes.getTypeCode(c = Filters.promote(lc, rc)), false)) != -3 && type != 2004) {
            castlhs = lhs.isConstant() && rhs.isConstant() || lc != c;
            boolean bl = castrhs = lhs.isConstant() && rhs.isConstant() || rc != c;
        }
        if (castlhs) {
            this.appendCast(buf, lhs, type);
        } else {
            lhs.appendTo(buf);
        }
        buf.append(" ").append(op).append(" ");
        if (castrhs) {
            this.appendCast(buf, rhs, type);
        } else {
            rhs.appendTo(buf);
        }
    }

    protected void appendNumericCast(SQLBuffer buf, FilterValue val) {
        if (val.isConstant()) {
            this.appendCast(buf, val, 2);
        } else {
            val.appendTo(buf);
        }
    }

    public void appendCast(SQLBuffer buf, FilterValue val, int type) {
        String post;
        int firstParam = this.castFunction.indexOf("{0}");
        String pre = this.castFunction.substring(0, firstParam);
        String mid = this.castFunction.substring(firstParam + 3);
        int secondParam = mid.indexOf("{1}");
        if (secondParam > -1) {
            post = mid.substring(secondParam + 3);
            mid = mid.substring(0, secondParam);
        } else {
            post = "";
        }
        buf.append(pre);
        val.appendTo(buf);
        buf.append(mid);
        buf.append(this.getTypeName(type));
        buf.append(post);
    }

    public void refSchemaComponents(Table table) {
    }

    public String getFullName(Table table, boolean logical) {
        if (!this.useSchemaName || table.getSchemaName() == null) {
            return table.getName();
        }
        if (logical || ".".equals(this.catalogSeparator)) {
            return table.getFullName();
        }
        return table.getSchemaName() + this.catalogSeparator + table.getName();
    }

    public String getFullName(Index index) {
        if (!this.useSchemaName || index.getSchemaName() == null) {
            return index.getName();
        }
        if (".".equals(this.catalogSeparator)) {
            return index.getFullName();
        }
        return index.getSchemaName() + this.catalogSeparator + index.getName();
    }

    public String getFullName(Sequence seq) {
        if (!this.useSchemaName || seq.getSchemaName() == null) {
            return seq.getName();
        }
        if (".".equals(this.catalogSeparator)) {
            return seq.getFullName();
        }
        return seq.getSchemaName() + this.catalogSeparator + seq.getName();
    }

    public String getValidTableName(String name, Schema schema) {
        while (name.startsWith("_")) {
            name = name.substring(1);
        }
        return this.makeNameValid(name, schema.getSchemaGroup(), this.maxTableNameLength, 1);
    }

    public String getValidSequenceName(String name, Schema schema) {
        while (name.startsWith("_")) {
            name = name.substring(1);
        }
        return this.makeNameValid("S_" + name, schema.getSchemaGroup(), this.maxTableNameLength, 2);
    }

    public String getValidColumnName(String name, Table table) {
        while (name.startsWith("_")) {
            name = name.substring(1);
        }
        return this.makeNameValid(name, table, this.maxColumnNameLength, 0);
    }

    public String getValidPrimaryKeyName(String name, Table table) {
        while (name.startsWith("_")) {
            name = name.substring(1);
        }
        return this.makeNameValid("P_" + name, table.getSchema().getSchemaGroup(), this.maxConstraintNameLength, 0);
    }

    public String getValidForeignKeyName(String name, Table table, Table toTable) {
        while (name.startsWith("_")) {
            name = name.substring(1);
        }
        String tableName = table.getName();
        int len = Math.min(tableName.length(), 7);
        name = "F_" + DBDictionary.shorten(tableName, len) + "_" + name;
        return this.makeNameValid(name, table.getSchema().getSchemaGroup(), this.maxConstraintNameLength, 0);
    }

    public String getValidIndexName(String name, Table table) {
        while (name.startsWith("_")) {
            name = name.substring(1);
        }
        String tableName = table.getName();
        int len = Math.min(tableName.length(), 7);
        name = "I_" + DBDictionary.shorten(tableName, len) + "_" + name;
        return this.makeNameValid(name, table.getSchema().getSchemaGroup(), this.maxIndexNameLength, 0);
    }

    public String getValidUniqueName(String name, Table table) {
        while (name.startsWith("_")) {
            name = name.substring(1);
        }
        String tableName = table.getName();
        int len = Math.min(tableName.length(), 7);
        name = "U_" + DBDictionary.shorten(tableName, len) + "_" + name;
        return this.makeNameValid(name, table.getSchema().getSchemaGroup(), this.maxConstraintNameLength, 0);
    }

    protected static String shorten(String name, int targetLength) {
        if (name == null || name.length() <= targetLength) {
            return name;
        }
        StringBuffer nm = new StringBuffer(name);
        while (nm.length() > targetLength) {
            if (DBDictionary.stripVowel(nm)) continue;
            nm.replace(nm.length() / 2, nm.length() / 2 + 1, "");
        }
        return nm.toString();
    }

    private static boolean stripVowel(StringBuffer name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        char[] vowels = new char[]{'A', 'E', 'I', 'O', 'U'};
        for (int i = 0; i < vowels.length; ++i) {
            int index = name.toString().toUpperCase().indexOf(vowels[i]);
            if (index == -1) continue;
            name.replace(index, index + 1, "");
            return true;
        }
        return false;
    }

    protected String makeNameValid(String name, NameSet set, int maxLen, int nameType) {
        if (maxLen < 1) {
            maxLen = 255;
        }
        if (name.length() > maxLen) {
            name = name.substring(0, maxLen);
        }
        if (this.reservedWordSet.contains(name.toUpperCase())) {
            if (name.length() == maxLen) {
                name = name.substring(0, name.length() - 1);
            }
            name = name + "0";
        }
        if (set != null) {
            int version = 1;
            int chars = 1;
            block4: while (true) {
                switch (nameType) {
                    case 1: {
                        if (((SchemaGroup)set).isKnownTable(name)) break;
                        break block4;
                    }
                    case 2: {
                        if (((SchemaGroup)set).isKnownSequence(name)) break;
                        break block4;
                    }
                    default: {
                        if (!set.isNameTaken(name)) break block4;
                    }
                }
                if (version > 1) {
                    name = name.substring(0, name.length() - chars);
                }
                if ((double)version >= Math.pow(10.0, chars)) {
                    ++chars;
                }
                if (name.length() + chars > maxLen) {
                    name = name.substring(0, maxLen - chars);
                }
                name = name + version;
                ++version;
            }
        }
        return name.toUpperCase();
    }

    public String[] getCreateTableSQL(Table table) {
        String pkStr;
        StringBuffer buf = new StringBuffer();
        buf.append("CREATE TABLE ").append(this.getFullName(table, false)).append(" (");
        Column[] cols = table.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.getDeclareColumnSQL(cols[i], false));
        }
        PrimaryKey pk = table.getPrimaryKey();
        if (pk != null && (pkStr = this.getPrimaryKeyConstraintSQL(pk)) != null) {
            buf.append(", ").append(pkStr);
        }
        Unique[] unqs = table.getUniques();
        for (int i = 0; i < unqs.length; ++i) {
            String unqStr = this.getUniqueConstraintSQL(unqs[i]);
            if (unqStr == null) continue;
            buf.append(", ").append(unqStr);
        }
        buf.append(")");
        return new String[]{buf.toString()};
    }

    public String[] getDropTableSQL(Table table) {
        String drop = MessageFormat.format(this.dropTableSQL, this.getFullName(table, false));
        return new String[]{drop};
    }

    public String[] getCreateSequenceSQL(Sequence seq) {
        if (this.nextSequenceQuery == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        buf.append("CREATE SEQUENCE ");
        buf.append(this.getFullName(seq));
        if (seq.getInitialValue() != 0) {
            buf.append(" START WITH ").append(seq.getInitialValue());
        }
        if (seq.getIncrement() > 1) {
            buf.append(" INCREMENT BY ").append(seq.getIncrement());
        }
        return new String[]{buf.toString()};
    }

    public String[] getDropSequenceSQL(Sequence seq) {
        return new String[]{"DROP SEQUENCE " + this.getFullName(seq)};
    }

    public String[] getCreateIndexSQL(Index index) {
        StringBuffer buf = new StringBuffer();
        buf.append("CREATE ");
        if (index.isUnique()) {
            buf.append("UNIQUE ");
        }
        buf.append("INDEX ").append(index.getName());
        buf.append(" ON ").append(this.getFullName(index.getTable(), false));
        buf.append(" (").append(Strings.join((Object[])index.getColumns(), (String)", ")).append(")");
        return new String[]{buf.toString()};
    }

    public String[] getDropIndexSQL(Index index) {
        return new String[]{"DROP INDEX " + this.getFullName(index)};
    }

    public String[] getAddColumnSQL(Column column) {
        if (!this.supportsAlterTableWithAddColumn) {
            return new String[0];
        }
        String dec = this.getDeclareColumnSQL(column, true);
        if (dec == null) {
            return new String[0];
        }
        return new String[]{"ALTER TABLE " + this.getFullName(column.getTable(), false) + " ADD " + dec};
    }

    public String[] getDropColumnSQL(Column column) {
        if (!this.supportsAlterTableWithDropColumn) {
            return new String[0];
        }
        return new String[]{"ALTER TABLE " + this.getFullName(column.getTable(), false) + " DROP COLUMN " + column};
    }

    public String[] getAddPrimaryKeySQL(PrimaryKey pk) {
        String pksql = this.getPrimaryKeyConstraintSQL(pk);
        if (pksql == null) {
            return new String[0];
        }
        return new String[]{"ALTER TABLE " + this.getFullName(pk.getTable(), false) + " ADD " + pksql};
    }

    public String[] getDropPrimaryKeySQL(PrimaryKey pk) {
        if (pk.getName() == null) {
            return new String[0];
        }
        return new String[]{"ALTER TABLE " + this.getFullName(pk.getTable(), false) + " DROP CONSTRAINT " + pk.getName()};
    }

    public String[] getAddForeignKeySQL(ForeignKey fk) {
        String fkSQL = this.getForeignKeyConstraintSQL(fk);
        if (fkSQL == null) {
            return new String[0];
        }
        return new String[]{"ALTER TABLE " + this.getFullName(fk.getTable(), false) + " ADD " + fkSQL};
    }

    public String[] getDropForeignKeySQL(ForeignKey fk) {
        if (fk.getName() == null) {
            return new String[0];
        }
        return new String[]{"ALTER TABLE " + this.getFullName(fk.getTable(), false) + " DROP CONSTRAINT " + fk.getName()};
    }

    protected String getDeclareColumnSQL(Column col, boolean alter) {
        StringBuffer buf = new StringBuffer();
        buf.append(col).append(" ");
        buf.append(this.getTypeName(col));
        if (!alter) {
            if (col.getDefaultString() != null && !col.isAutoAssigned()) {
                buf.append(" DEFAULT ").append(col.getDefaultString());
            }
            if (col.isNotNull()) {
                buf.append(" NOT NULL");
            }
        }
        if (col.isAutoAssigned()) {
            if (!this.supportsAutoAssign) {
                this.log.warn(_loc.get("invalid-autoassign", this.platform, col));
            } else if (this.autoAssignClause != null) {
                buf.append(" ").append(this.autoAssignClause);
            }
        }
        return buf.toString();
    }

    protected String getPrimaryKeyConstraintSQL(PrimaryKey pk) {
        if (!this.createPrimaryKeys) {
            return null;
        }
        String name = pk.getName();
        if (name != null && this.reservedWordSet.contains(name.toUpperCase())) {
            name = null;
        }
        StringBuffer buf = new StringBuffer();
        if (name != null && CONS_NAME_BEFORE.equals(this.constraintNameMode)) {
            buf.append("CONSTRAINT ").append(name).append(" ");
        }
        buf.append("PRIMARY KEY ");
        if (name != null && CONS_NAME_MID.equals(this.constraintNameMode)) {
            buf.append(name).append(" ");
        }
        buf.append("(").append(Strings.join((Object[])pk.getColumns(), (String)", ")).append(")");
        if (name != null && CONS_NAME_AFTER.equals(this.constraintNameMode)) {
            buf.append(" CONSTRAINT ").append(name);
        }
        return buf.toString();
    }

    protected String getForeignKeyConstraintSQL(ForeignKey fk) {
        if (!this.supportsForeignKeys) {
            return null;
        }
        if (fk.getDeleteAction() == 1) {
            return null;
        }
        if (fk.isDeferred() && !this.supportsDeferredConstraints) {
            return null;
        }
        if (!this.supportsDeleteAction(fk.getDeleteAction()) || !this.supportsUpdateAction(fk.getUpdateAction())) {
            return null;
        }
        Object[] locals = fk.getColumns();
        Object[] foreigns = fk.getPrimaryKeyColumns();
        int delActionId = fk.getDeleteAction();
        if (delActionId == 4) {
            for (int i = 0; i < locals.length; ++i) {
                if (!locals[i].isNotNull()) continue;
                delActionId = 1;
            }
        }
        String delAction = this.getActionName(delActionId);
        String upAction = this.getActionName(fk.getUpdateAction());
        StringBuffer buf = new StringBuffer();
        if (fk.getName() != null && CONS_NAME_BEFORE.equals(this.constraintNameMode)) {
            buf.append("CONSTRAINT ").append(fk.getName()).append(" ");
        }
        buf.append("FOREIGN KEY ");
        if (fk.getName() != null && CONS_NAME_MID.equals(this.constraintNameMode)) {
            buf.append(fk.getName()).append(" ");
        }
        buf.append("(").append(Strings.join((Object[])locals, (String)", ")).append(")");
        buf.append(" REFERENCES ");
        buf.append(this.getFullName(foreigns[0].getTable(), false));
        buf.append(" (").append(Strings.join((Object[])foreigns, (String)", ")).append(")");
        if (delAction != null) {
            buf.append(" ON DELETE ").append(delAction);
        }
        if (upAction != null) {
            buf.append(" ON UPDATE ").append(upAction);
        }
        if (fk.isDeferred()) {
            buf.append(" INITIALLY DEFERRED");
        }
        if (this.supportsDeferredConstraints) {
            buf.append(" DEFERRABLE");
        }
        if (fk.getName() != null && CONS_NAME_AFTER.equals(this.constraintNameMode)) {
            buf.append(" CONSTRAINT ").append(fk.getName());
        }
        return buf.toString();
    }

    private String getActionName(int action) {
        switch (action) {
            case 3: {
                return "CASCADE";
            }
            case 4: {
                return "SET NULL";
            }
            case 5: {
                return "SET DEFAULT";
            }
        }
        return null;
    }

    public boolean supportsDeleteAction(int action) {
        if (action == 1) {
            return true;
        }
        if (!this.supportsForeignKeys) {
            return false;
        }
        switch (action) {
            case 2: {
                return this.supportsRestrictDeleteAction;
            }
            case 3: {
                return this.supportsCascadeDeleteAction;
            }
            case 4: {
                return this.supportsNullDeleteAction;
            }
            case 5: {
                return this.supportsDefaultDeleteAction;
            }
        }
        return false;
    }

    public boolean supportsUpdateAction(int action) {
        if (action == 1) {
            return true;
        }
        if (!this.supportsForeignKeys) {
            return false;
        }
        switch (action) {
            case 2: {
                return this.supportsRestrictUpdateAction;
            }
            case 3: {
                return this.supportsCascadeUpdateAction;
            }
            case 4: {
                return this.supportsNullUpdateAction;
            }
            case 5: {
                return this.supportsDefaultUpdateAction;
            }
        }
        return false;
    }

    protected String getUniqueConstraintSQL(Unique unq) {
        if (!this.supportsUniqueConstraints || unq.isDeferred() && !this.supportsDeferredConstraints) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        if (unq.getName() != null && CONS_NAME_BEFORE.equals(this.constraintNameMode)) {
            buf.append("CONSTRAINT ").append(unq.getName()).append(" ");
        }
        buf.append("UNIQUE ");
        if (unq.getName() != null && CONS_NAME_MID.equals(this.constraintNameMode)) {
            buf.append(unq.getName()).append(" ");
        }
        buf.append("(").append(Strings.join((Object[])unq.getColumns(), (String)", ")).append(")");
        if (unq.isDeferred()) {
            buf.append(" INITIALLY DEFERRED");
        }
        if (this.supportsDeferredConstraints) {
            buf.append(" DEFERRABLE");
        }
        if (unq.getName() != null && CONS_NAME_AFTER.equals(this.constraintNameMode)) {
            buf.append(" CONSTRAINT ").append(unq.getName());
        }
        return buf.toString();
    }

    public boolean isSystemTable(String name, String schema, boolean targetSchema) {
        if (this.systemTableSet.contains(name.toUpperCase())) {
            return true;
        }
        return !targetSchema && schema != null && this.systemSchemaSet.contains(schema.toUpperCase());
    }

    public boolean isSystemIndex(String name, Table table) {
        return false;
    }

    public boolean isSystemSequence(String name, String schema, boolean targetSchema) {
        return !targetSchema && schema != null && this.systemSchemaSet.contains(schema.toUpperCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table[] getTables(DatabaseMetaData meta, String catalog, String schemaName, String tableName, Connection conn) throws SQLException {
        schemaName = !this.supportsSchemaForGetTables ? null : this.getSchemaNameForMetadata(schemaName);
        String[] types = Strings.split((String)this.tableTypes, (String)",", (int)0);
        for (int i = 0; i < types.length; ++i) {
            types[i] = types[i].trim();
        }
        this.beforeMetadataOperation(conn);
        ResultSet tables = null;
        try {
            tables = meta.getTables(this.getCatalogNameForMetadata(catalog), schemaName, this.getTableNameForMetadata(tableName), types);
            ArrayList<Table> tableList = new ArrayList<Table>();
            while (tables != null && tables.next()) {
                tableList.add(this.newTable(tables));
            }
            Table[] tableArray = tableList.toArray(new Table[tableList.size()]);
            return tableArray;
        }
        finally {
            if (tables != null) {
                try {
                    tables.close();
                }
                catch (Exception e) {}
            }
        }
    }

    protected Table newTable(ResultSet tableMeta) throws SQLException {
        Table t = new Table();
        t.setName(tableMeta.getString("TABLE_NAME"));
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence[] getSequences(DatabaseMetaData meta, String catalog, String schemaName, String sequenceName, Connection conn) throws SQLException {
        String str = this.getSequencesSQL(schemaName, sequenceName);
        if (str == null) {
            return new Sequence[0];
        }
        PreparedStatement stmnt = conn.prepareStatement(str);
        ResultSet rs = null;
        try {
            int idx = 1;
            if (schemaName != null) {
                stmnt.setString(idx++, schemaName);
            }
            if (sequenceName != null) {
                stmnt.setString(idx++, sequenceName);
            }
            rs = stmnt.executeQuery();
            ArrayList<Sequence> seqList = new ArrayList<Sequence>();
            while (rs.next()) {
                seqList.add(this.newSequence(rs));
            }
            Sequence[] sequenceArray = seqList.toArray(new Sequence[seqList.size()]);
            return sequenceArray;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException se) {}
            }
            try {
                stmnt.close();
            }
            catch (SQLException se) {}
        }
    }

    protected Sequence newSequence(ResultSet sequenceMeta) throws SQLException {
        Sequence seq = new Sequence();
        seq.setSchemaName(sequenceMeta.getString("SEQUENCE_SCHEMA"));
        seq.setName(sequenceMeta.getString("SEQUENCE_NAME"));
        return seq;
    }

    protected String getSequencesSQL(String schemaName, String sequenceName) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Column[] getColumns(DatabaseMetaData meta, String catalog, String schemaName, String tableName, String columnName, Connection conn) throws SQLException {
        if (tableName == null && !this.supportsNullTableForGetColumns) {
            return null;
        }
        schemaName = !this.supportsSchemaForGetColumns ? null : this.getSchemaNameForMetadata(schemaName);
        this.beforeMetadataOperation(conn);
        ResultSet cols = null;
        try {
            cols = meta.getColumns(this.getCatalogNameForMetadata(catalog), schemaName, this.getTableNameForMetadata(tableName), this.getColumnNameForMetadata(columnName));
            ArrayList<Column> columnList = new ArrayList<Column>();
            while (cols != null && cols.next()) {
                columnList.add(this.newColumn(cols));
            }
            Column[] columnArray = columnList.toArray(new Column[columnList.size()]);
            return columnArray;
        }
        finally {
            if (cols != null) {
                try {
                    cols.close();
                }
                catch (Exception e) {}
            }
        }
    }

    protected Column newColumn(ResultSet colMeta) throws SQLException {
        Column c = new Column();
        c.setSchemaName(colMeta.getString("TABLE_SCHEM"));
        c.setTableName(colMeta.getString("TABLE_NAME"));
        c.setName(colMeta.getString("COLUMN_NAME"));
        c.setType(colMeta.getInt("DATA_TYPE"));
        c.setTypeName(colMeta.getString("TYPE_NAME"));
        c.setSize(colMeta.getInt("COLUMN_SIZE"));
        c.setDecimalDigits(colMeta.getInt("DECIMAL_DIGITS"));
        c.setNotNull(colMeta.getInt("NULLABLE") == 0);
        String def = colMeta.getString("COLUMN_DEF");
        if (!StringUtils.isEmpty((String)def) && !"null".equalsIgnoreCase(def)) {
            c.setDefaultString(def);
        }
        return c;
    }

    public PrimaryKey[] getPrimaryKeys(DatabaseMetaData meta, String catalog, String schemaName, String tableName, Connection conn) throws SQLException {
        if (this.useGetBestRowIdentifierForPrimaryKeys) {
            return this.getPrimaryKeysFromBestRowIdentifier(meta, catalog, schemaName, tableName, conn);
        }
        return this.getPrimaryKeysFromGetPrimaryKeys(meta, catalog, schemaName, tableName, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PrimaryKey[] getPrimaryKeysFromGetPrimaryKeys(DatabaseMetaData meta, String catalog, String schemaName, String tableName, Connection conn) throws SQLException {
        if (tableName == null && !this.supportsNullTableForGetPrimaryKeys) {
            return null;
        }
        this.beforeMetadataOperation(conn);
        ResultSet pks = null;
        try {
            pks = meta.getPrimaryKeys(this.getCatalogNameForMetadata(catalog), this.getSchemaNameForMetadata(schemaName), this.getTableNameForMetadata(tableName));
            ArrayList<PrimaryKey> pkList = new ArrayList<PrimaryKey>();
            while (pks != null && pks.next()) {
                pkList.add(this.newPrimaryKey(pks));
            }
            PrimaryKey[] primaryKeyArray = pkList.toArray(new PrimaryKey[pkList.size()]);
            return primaryKeyArray;
        }
        finally {
            if (pks != null) {
                try {
                    pks.close();
                }
                catch (Exception e) {}
            }
        }
    }

    protected PrimaryKey newPrimaryKey(ResultSet pkMeta) throws SQLException {
        PrimaryKey pk = new PrimaryKey();
        pk.setSchemaName(pkMeta.getString("TABLE_SCHEM"));
        pk.setTableName(pkMeta.getString("TABLE_NAME"));
        pk.setColumnName(pkMeta.getString("COLUMN_NAME"));
        pk.setName(pkMeta.getString("PK_NAME"));
        return pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PrimaryKey[] getPrimaryKeysFromBestRowIdentifier(DatabaseMetaData meta, String catalog, String schemaName, String tableName, Connection conn) throws SQLException {
        if (tableName == null) {
            return null;
        }
        this.beforeMetadataOperation(conn);
        ResultSet pks = null;
        try {
            pks = meta.getBestRowIdentifier(catalog, schemaName, tableName, 0, false);
            ArrayList<PrimaryKey> pkList = new ArrayList<PrimaryKey>();
            while (pks != null && pks.next()) {
                PrimaryKey pk = new PrimaryKey();
                pk.setSchemaName(schemaName);
                pk.setTableName(tableName);
                pk.setColumnName(pks.getString("COLUMN_NAME"));
                pkList.add(pk);
            }
            PrimaryKey[] primaryKeyArray = pkList.toArray(new PrimaryKey[pkList.size()]);
            return primaryKeyArray;
        }
        finally {
            if (pks != null) {
                try {
                    pks.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Index[] getIndexInfo(DatabaseMetaData meta, String catalog, String schemaName, String tableName, boolean unique, boolean approx, Connection conn) throws SQLException {
        if (tableName == null && !this.supportsNullTableForGetIndexInfo) {
            return null;
        }
        this.beforeMetadataOperation(conn);
        ResultSet indexes = null;
        try {
            indexes = meta.getIndexInfo(this.getCatalogNameForMetadata(catalog), this.getSchemaNameForMetadata(schemaName), this.getTableNameForMetadata(tableName), unique, approx);
            ArrayList<Index> indexList = new ArrayList<Index>();
            while (indexes != null && indexes.next()) {
                indexList.add(this.newIndex(indexes));
            }
            Index[] indexArray = indexList.toArray(new Index[indexList.size()]);
            return indexArray;
        }
        finally {
            if (indexes != null) {
                try {
                    indexes.close();
                }
                catch (Exception e) {}
            }
        }
    }

    protected Index newIndex(ResultSet idxMeta) throws SQLException {
        Index idx = new Index();
        idx.setSchemaName(idxMeta.getString("TABLE_SCHEM"));
        idx.setTableName(idxMeta.getString("TABLE_NAME"));
        idx.setColumnName(idxMeta.getString("COLUMN_NAME"));
        idx.setName(idxMeta.getString("INDEX_NAME"));
        idx.setUnique(!idxMeta.getBoolean("NON_UNIQUE"));
        return idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForeignKey[] getImportedKeys(DatabaseMetaData meta, String catalog, String schemaName, String tableName, Connection conn) throws SQLException {
        if (!this.supportsForeignKeys) {
            return null;
        }
        if (tableName == null && !this.supportsNullTableForGetImportedKeys) {
            return null;
        }
        this.beforeMetadataOperation(conn);
        ResultSet keys = null;
        try {
            keys = meta.getImportedKeys(this.getCatalogNameForMetadata(catalog), this.getSchemaNameForMetadata(schemaName), this.getTableNameForMetadata(tableName));
            ArrayList<ForeignKey> importedKeyList = new ArrayList<ForeignKey>();
            while (keys != null && keys.next()) {
                importedKeyList.add(this.newForeignKey(keys));
            }
            ForeignKey[] foreignKeyArray = importedKeyList.toArray(new ForeignKey[importedKeyList.size()]);
            return foreignKeyArray;
        }
        finally {
            if (keys != null) {
                try {
                    keys.close();
                }
                catch (Exception e) {}
            }
        }
    }

    protected ForeignKey newForeignKey(ResultSet fkMeta) throws SQLException {
        ForeignKey fk = new ForeignKey();
        fk.setSchemaName(fkMeta.getString("FKTABLE_SCHEM"));
        fk.setTableName(fkMeta.getString("FKTABLE_NAME"));
        fk.setColumnName(fkMeta.getString("FKCOLUMN_NAME"));
        fk.setName(fkMeta.getString("FK_NAME"));
        fk.setPrimaryKeySchemaName(fkMeta.getString("PKTABLE_SCHEM"));
        fk.setPrimaryKeyTableName(fkMeta.getString("PKTABLE_NAME"));
        fk.setPrimaryKeyColumnName(fkMeta.getString("PKCOLUMN_NAME"));
        fk.setKeySequence(fkMeta.getInt("KEY_SEQ"));
        fk.setDeferred(fkMeta.getInt("DEFERRABILITY") == 5);
        int del = fkMeta.getInt("DELETE_RULE");
        switch (del) {
            case 2: {
                fk.setDeleteAction(4);
                break;
            }
            case 4: {
                fk.setDeleteAction(5);
                break;
            }
            case 0: {
                fk.setDeleteAction(3);
                break;
            }
            default: {
                fk.setDeleteAction(2);
            }
        }
        return fk;
    }

    protected String getTableNameForMetadata(String tableName) {
        return this.convertSchemaCase(tableName);
    }

    protected String getSchemaNameForMetadata(String schemaName) {
        if (schemaName == null) {
            schemaName = this.conf.getSchema();
        }
        return this.convertSchemaCase(schemaName);
    }

    protected String getCatalogNameForMetadata(String catalogName) {
        return this.convertSchemaCase(catalogName);
    }

    protected String getColumnNameForMetadata(String columnName) {
        return this.convertSchemaCase(columnName);
    }

    protected String convertSchemaCase(String objectName) {
        if (objectName == null) {
            return null;
        }
        if (SCHEMA_CASE_LOWER.equals(this.schemaCase)) {
            return objectName.toLowerCase();
        }
        if (SCHEMA_CASE_PRESERVE.equals(this.schemaCase)) {
            return objectName;
        }
        return objectName.toUpperCase();
    }

    private void beforeMetadataOperation(Connection c) {
        if (this.requiresAutoCommitForMetaData) {
            try {
                c.rollback();
            }
            catch (SQLException sqle) {
                // empty catch block
            }
            try {
                if (!c.getAutoCommit()) {
                    c.setAutoCommit(true);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getGeneratedKey(Column col, Connection conn) throws SQLException {
        if (this.lastGeneratedKeyQuery == null) {
            throw new StoreException(_loc.get("no-auto-assign"));
        }
        String query = this.lastGeneratedKeyQuery;
        if (query.indexOf(123) != -1) {
            query = MessageFormat.format(query, col.getName(), this.getFullName(col.getTable(), false), this.getGeneratedKeySequenceName(col));
        }
        PreparedStatement stmnt = conn.prepareStatement(query);
        ResultSet rs = null;
        try {
            rs = stmnt.executeQuery();
            if (!rs.next()) {
                throw new StoreException(_loc.get("no-genkey"));
            }
            Object key = rs.getObject(1);
            if (key == null) {
                this.log.warn(_loc.get("invalid-genkey", col));
            }
            Object object = key;
            return object;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException se) {}
            }
            try {
                stmnt.close();
            }
            catch (SQLException se) {}
        }
    }

    protected String getGeneratedKeySequenceName(Column col) {
        String tname = col.getTableName();
        String cname = col.getName();
        int max = this.maxAutoAssignNameLength;
        int extraChars = -max + tname.length() + 1 + cname.length() + 4;
        if (extraChars > 0) {
            tname = tname.substring(0, tname.length() - extraChars);
        }
        StringBuffer buf = new StringBuffer(max);
        buf.append(tname).append("_").append(cname).append("_SEQ");
        return buf.toString();
    }

    public void setConfiguration(Configuration conf) {
        this.conf = (JDBCConfiguration)conf;
        this.log = this.conf.getLog("openjpa.jdbc.JDBC");
        if (this.log.isWarnEnabled() && !this.isSupported()) {
            this.log.warn(_loc.get("dict-not-supported", this.getClass()));
        }
    }

    private boolean isSupported() {
        Class<?> c = this.getClass();
        while (!c.getName().startsWith("org.apache.openjpa.")) {
            c = c.getSuperclass();
        }
        return c != DBDictionary.class;
    }

    public void startConfiguration() {
    }

    public void endConfiguration() {
        InputStream in = DBDictionary.class.getResourceAsStream("sql-keywords.rsrc");
        try {
            String keywords = new BufferedReader(new InputStreamReader(in)).readLine();
            in.close();
            this.reservedWordSet.addAll(Arrays.asList(Strings.split((String)keywords, (String)",", (int)0)));
        }
        catch (IOException ioe) {
            throw new GeneralException(ioe);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
        if (this.reservedWords != null) {
            this.reservedWordSet.addAll(Arrays.asList(Strings.split((String)this.reservedWords.toUpperCase(), (String)",", (int)0)));
        }
        if (this.systemSchemas != null) {
            this.systemSchemaSet.addAll(Arrays.asList(Strings.split((String)this.systemSchemas.toUpperCase(), (String)",", (int)0)));
        }
        if (this.systemTables != null) {
            this.systemTableSet.addAll(Arrays.asList(Strings.split((String)this.systemTables.toUpperCase(), (String)",", (int)0)));
        }
        if (this.fixedSizeTypeNames != null) {
            this.fixedSizeTypeNameSet.addAll(Arrays.asList(Strings.split((String)this.fixedSizeTypeNames.toUpperCase(), (String)",", (int)0)));
        }
        this.nextSequenceQuery = StringUtils.trimToNull((String)this.nextSequenceQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection decorate(Connection conn) throws SQLException {
        if (!this.connected) {
            this.connectedConfiguration(conn);
        }
        if (!StringUtils.isEmpty((String)this.initializationSQL)) {
            PreparedStatement stmnt = null;
            try {
                stmnt = conn.prepareStatement(this.initializationSQL);
                stmnt.execute();
            }
            catch (Exception e) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace(e.toString(), e);
                }
            }
            finally {
                if (stmnt != null) {
                    try {
                        stmnt.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return conn;
    }

    public void handleWarning(SQLWarning warning) throws SQLException {
    }

    public OpenJPAException newStoreException(String msg, SQLException[] causes, Object failed) {
        if (causes.length > 0 && "23000".equals(causes[0].getSQLState())) {
            return new ReferentialIntegrityException(msg).setFailedObject(failed).setNestedThrowables(causes);
        }
        return new StoreException(msg).setFailedObject(failed).setNestedThrowables(causes);
    }

    public void closeDataSource(DataSource dataSource) {
        DataSourceFactory.closeDataSource(dataSource);
    }

    public static class SerializedData {
        public final byte[] bytes;

        public SerializedData(byte[] bytes) {
            this.bytes = bytes;
        }
    }
}

