/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.sql.AbstractSQLServerDictionary;
import org.apache.openjpa.lib.util.Localizer;

public class SQLServerDictionary
extends AbstractSQLServerDictionary {
    public static final String VENDOR_MICROSOFT = "microsoft";
    public static final String VENDOR_NETDIRECT = "netdirect";
    public static final String VENDOR_JTDS = "jtds";
    private static final Localizer _loc = Localizer.forPackage(SQLServerDictionary.class);
    public boolean uniqueIdentifierAsVarbinary = true;

    public SQLServerDictionary() {
        this.platform = "Microsoft SQL Server";
        this.forUpdateClause = null;
        this.tableForUpdateClause = "WITH (UPDLOCK)";
        this.supportsNullTableForGetColumns = false;
        this.requiresAliasForSubselect = true;
        this.stringLengthFunction = "LEN({0})";
    }

    public void connectedConfiguration(Connection conn) throws SQLException {
        String props;
        super.connectedConfiguration(conn);
        DatabaseMetaData meta = conn.getMetaData();
        String driverName = meta.getDriverName();
        String url = meta.getURL();
        if (this.driverVendor == null) {
            this.driverVendor = "NetDirect JSQLConnect".equals(driverName) ? VENDOR_NETDIRECT : (driverName != null && driverName.startsWith("jTDS") ? VENDOR_JTDS : ("SQLServer".equals(driverName) ? (url != null && url.startsWith("jdbc:microsoft:sqlserver:") ? VENDOR_MICROSOFT : (url != null && url.startsWith("jdbc:datadirect:sqlserver:") ? "datadirect" : "other")) : "other"));
        }
        if ((VENDOR_MICROSOFT.equalsIgnoreCase(this.driverVendor) || "datadirect".equalsIgnoreCase(this.driverVendor)) && url.toLowerCase().indexOf("selectmethod=cursor") == -1) {
            this.log.warn(_loc.get("sqlserver-cursor", url));
        }
        if ((props = this.conf.getConnectionFactoryProperties()) == null) {
            props = "";
        }
        if (VENDOR_MICROSOFT.equalsIgnoreCase(this.driverVendor) && props.toLowerCase().indexOf("maxcachedstatements=0") == -1) {
            this.log.warn(_loc.get("sqlserver-cachedstmnts"));
        }
    }

    public Column[] getColumns(DatabaseMetaData meta, String catalog, String schemaName, String tableName, String columnName, Connection conn) throws SQLException {
        Column[] cols = super.getColumns(meta, catalog, schemaName, tableName, columnName, conn);
        for (int i = 0; cols != null && i < cols.length; ++i) {
            String typeName = cols[i].getTypeName();
            if (typeName == null) continue;
            if ("NVARCHAR".equals(typeName = typeName.toUpperCase())) {
                cols[i].setType(12);
                continue;
            }
            if ("UNIQUEIDENTIFIER".equals(typeName)) {
                if (this.uniqueIdentifierAsVarbinary) {
                    cols[i].setType(-3);
                    continue;
                }
                cols[i].setType(12);
                continue;
            }
            if ("NCHAR".equals(typeName)) {
                cols[i].setType(1);
                continue;
            }
            if (!"NTEXT".equals(typeName)) continue;
            cols[i].setType(2005);
        }
        return cols;
    }
}

