/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.util.Collection;
import java.util.Set;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.lib.rop.ResultList;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.util.RuntimeExceptionTranslator;

public class DelegatingFetchConfiguration
implements FetchConfiguration {
    private final FetchConfiguration _fetch;
    private final DelegatingFetchConfiguration _del;
    private final RuntimeExceptionTranslator _trans;

    public DelegatingFetchConfiguration(FetchConfiguration fetch) {
        this(fetch, null);
    }

    public DelegatingFetchConfiguration(FetchConfiguration fetch, RuntimeExceptionTranslator trans) {
        this._fetch = fetch;
        this._del = fetch instanceof DelegatingFetchConfiguration ? (DelegatingFetchConfiguration)fetch : null;
        this._trans = trans;
    }

    public FetchConfiguration getDelegate() {
        return this._fetch;
    }

    public FetchConfiguration getInnermostDelegate() {
        return this._del == null ? this._fetch : this._del.getInnermostDelegate();
    }

    public int hashCode() {
        return this.getInnermostDelegate().hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DelegatingFetchConfiguration) {
            other = ((DelegatingFetchConfiguration)other).getInnermostDelegate();
        }
        return this.getInnermostDelegate().equals(other);
    }

    protected RuntimeException translate(RuntimeException re) {
        return this._trans == null ? re : this._trans.translate(re);
    }

    public StoreContext getContext() {
        try {
            return this._fetch.getContext();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public void setContext(StoreContext ctx) {
        try {
            this._fetch.setContext(ctx);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public int getFetchBatchSize() {
        try {
            return this._fetch.getFetchBatchSize();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public FetchConfiguration setFetchBatchSize(int fetchBatchSize) {
        try {
            this._fetch.setFetchBatchSize(fetchBatchSize);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public int getMaxFetchDepth() {
        try {
            return this._fetch.getMaxFetchDepth();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public FetchConfiguration setMaxFetchDepth(int depth) {
        try {
            this._fetch.setMaxFetchDepth(depth);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public Set getRootInstances() {
        try {
            return this._fetch.getRootInstances();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public FetchConfiguration setRootInstances(Collection roots) {
        try {
            this._fetch.setRootInstances(roots);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public Set getRootClasses() {
        try {
            return this._fetch.getRootClasses();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public FetchConfiguration setRootClasses(Collection roots) {
        try {
            this._fetch.setRootClasses(roots);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public boolean getQueryCache() {
        try {
            return this._fetch.getQueryCache();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public FetchConfiguration setQueryCache(boolean cache) {
        try {
            this._fetch.setQueryCache(cache);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public int getFlushBeforeQueries() {
        try {
            return this._fetch.getFlushBeforeQueries();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public FetchConfiguration setFlushBeforeQueries(int flush) {
        try {
            this._fetch.setFlushBeforeQueries(flush);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public Set getFetchGroups() {
        try {
            return this._fetch.getFetchGroups();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public boolean hasFetchGroup(String group) {
        try {
            return this._fetch.hasFetchGroup(group);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public FetchConfiguration addFetchGroup(String group) {
        try {
            this._fetch.addFetchGroup(group);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public FetchConfiguration addFetchGroups(Collection groups) {
        try {
            this._fetch.addFetchGroups(groups);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public FetchConfiguration removeFetchGroup(String group) {
        try {
            this._fetch.removeFetchGroup(group);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public FetchConfiguration removeFetchGroups(Collection groups) {
        try {
            this._fetch.removeFetchGroups(groups);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public FetchConfiguration clearFetchGroups() {
        try {
            this._fetch.clearFetchGroups();
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public FetchConfiguration resetFetchGroups() {
        try {
            this._fetch.resetFetchGroups();
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public Set getFields() {
        try {
            return this._fetch.getFields();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public boolean hasField(String field) {
        try {
            return this._fetch.hasField(field);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public FetchConfiguration addField(String field) {
        try {
            this._fetch.addField(field);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public FetchConfiguration addFields(Collection fields) {
        try {
            this._fetch.addFields(fields);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public FetchConfiguration removeField(String field) {
        try {
            this._fetch.removeField(field);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public FetchConfiguration removeFields(Collection fields) {
        try {
            this._fetch.removeFields(fields);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public FetchConfiguration clearFields() {
        try {
            this._fetch.clearFields();
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public int getLockTimeout() {
        try {
            return this._fetch.getLockTimeout();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public FetchConfiguration setLockTimeout(int timeout) {
        try {
            this._fetch.setLockTimeout(timeout);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public int getReadLockLevel() {
        try {
            return this._fetch.getReadLockLevel();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public FetchConfiguration setReadLockLevel(int level) {
        try {
            this._fetch.setReadLockLevel(level);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public int getWriteLockLevel() {
        try {
            return this._fetch.getWriteLockLevel();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public FetchConfiguration setWriteLockLevel(int level) {
        try {
            this._fetch.setWriteLockLevel(level);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public ResultList newResultList(ResultObjectProvider rop) {
        try {
            return this._fetch.newResultList(rop);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public void copy(FetchConfiguration fetch) {
        try {
            this._fetch.copy(fetch);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public Object clone() {
        try {
            return this._fetch.clone();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public void setHint(String name, Object value) {
        try {
            this._fetch.setHint(name, value);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public Object getHint(String name) {
        try {
            return this._fetch.getHint(name);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public int requiresFetch(FieldMetaData fmd) {
        try {
            return this._fetch.requiresFetch(fmd);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public boolean requiresLoad() {
        try {
            return this._fetch.requiresLoad();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public FetchConfiguration traverse(FieldMetaData fmd) {
        try {
            return this._fetch.traverse(fmd);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public void lock() {
        try {
            this._fetch.lock();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public void unlock() {
        try {
            this._fetch.unlock();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }
}

