/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.openjpa.lib.rop.ResultList;
import org.apache.openjpa.util.RuntimeExceptionTranslator;

public class DelegatingResultList
implements ResultList {
    private final ResultList _del;
    private final RuntimeExceptionTranslator _trans;

    public DelegatingResultList(ResultList list) {
        this(list, null);
    }

    public DelegatingResultList(ResultList list, RuntimeExceptionTranslator trans) {
        this._del = list;
        this._trans = trans;
    }

    public ResultList getDelegate() {
        return this._del;
    }

    public ResultList getInnermostDelegate() {
        return this._del instanceof DelegatingResultList ? ((DelegatingResultList)this._del).getInnermostDelegate() : this._del;
    }

    public Object writeReplace() throws ObjectStreamException {
        return this._del;
    }

    public int hashCode() {
        try {
            return this.getInnermostDelegate().hashCode();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DelegatingResultList) {
            other = ((DelegatingResultList)other).getInnermostDelegate();
        }
        try {
            return this.getInnermostDelegate().equals(other);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    protected RuntimeException translate(RuntimeException re) {
        return this._trans == null ? re : this._trans.translate(re);
    }

    public boolean isProviderOpen() {
        try {
            return this._del.isProviderOpen();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public void close() {
        try {
            this._del.close();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public boolean isClosed() {
        try {
            return this._del.isClosed();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public int size() {
        try {
            return this._del.size();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public boolean isEmpty() {
        try {
            return this._del.isEmpty();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public boolean contains(Object o) {
        try {
            return this._del.contains(o);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public Iterator iterator() {
        return this.listIterator();
    }

    public Object[] toArray() {
        try {
            return this._del.toArray();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public Object[] toArray(Object[] a) {
        try {
            return this._del.toArray(a);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public boolean add(Object o) {
        try {
            return this._del.add(o);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public boolean remove(Object o) {
        try {
            return this._del.remove(o);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public boolean containsAll(Collection c) {
        try {
            return this._del.containsAll(c);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public boolean addAll(Collection c) {
        try {
            return this._del.addAll(c);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public boolean addAll(int index, Collection c) {
        try {
            return this._del.addAll(index, c);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public boolean removeAll(Collection c) {
        try {
            return this._del.removeAll(c);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public boolean retainAll(Collection c) {
        try {
            return this._del.retainAll(c);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public void clear() {
        try {
            this._del.clear();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public Object get(int index) {
        try {
            return this._del.get(index);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public Object set(int index, Object element) {
        try {
            return this._del.set(index, element);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public void add(int index, Object element) {
        try {
            this._del.add(index, element);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public Object remove(int index) {
        try {
            return this._del.remove(index);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public int indexOf(Object o) {
        try {
            return this._del.indexOf(o);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public int lastIndexOf(Object o) {
        try {
            return this._del.lastIndexOf(o);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public ListIterator listIterator() {
        try {
            return new DelegatingListIterator(this._del.listIterator());
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public ListIterator listIterator(int index) {
        try {
            return new DelegatingListIterator(this._del.listIterator(index));
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public List subList(int fromIndex, int toIndex) {
        try {
            return this._del.subList(fromIndex, toIndex);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public class DelegatingListIterator
    implements ListIterator {
        private final ListIterator _del;

        public DelegatingListIterator(ListIterator it) {
            this._del = it;
        }

        public ListIterator getDelegate() {
            return this._del;
        }

        public ListIterator getInnermostDelegate() {
            return this._del instanceof DelegatingListIterator ? ((DelegatingListIterator)this._del).getInnermostDelegate() : this._del;
        }

        public int hashCode() {
            try {
                return this.getInnermostDelegate().hashCode();
            }
            catch (RuntimeException re) {
                throw DelegatingResultList.this.translate(re);
            }
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof DelegatingListIterator) {
                other = ((DelegatingListIterator)other).getInnermostDelegate();
            }
            try {
                return this.getInnermostDelegate().equals(other);
            }
            catch (RuntimeException re) {
                throw DelegatingResultList.this.translate(re);
            }
        }

        public boolean hasNext() {
            try {
                return this._del.hasNext();
            }
            catch (RuntimeException re) {
                throw DelegatingResultList.this.translate(re);
            }
        }

        public Object next() {
            try {
                return this._del.next();
            }
            catch (RuntimeException re) {
                throw DelegatingResultList.this.translate(re);
            }
        }

        public boolean hasPrevious() {
            try {
                return this._del.hasPrevious();
            }
            catch (RuntimeException re) {
                throw DelegatingResultList.this.translate(re);
            }
        }

        public Object previous() {
            try {
                return this._del.previous();
            }
            catch (RuntimeException re) {
                throw DelegatingResultList.this.translate(re);
            }
        }

        public int nextIndex() {
            try {
                return this._del.nextIndex();
            }
            catch (RuntimeException re) {
                throw DelegatingResultList.this.translate(re);
            }
        }

        public int previousIndex() {
            try {
                return this._del.previousIndex();
            }
            catch (RuntimeException re) {
                throw DelegatingResultList.this.translate(re);
            }
        }

        public void remove() {
            try {
                this._del.remove();
            }
            catch (RuntimeException re) {
                throw DelegatingResultList.this.translate(re);
            }
        }

        public void set(Object o) {
            try {
                this._del.set(o);
            }
            catch (RuntimeException re) {
                throw DelegatingResultList.this.translate(re);
            }
        }

        public void add(Object o) {
            try {
                this._del.add(o);
            }
            catch (RuntimeException re) {
                throw DelegatingResultList.this.translate(re);
            }
        }
    }
}

