/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.meta;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.openjpa.lib.meta.MetaDataIterator;
import org.apache.openjpa.lib.util.MultiClassLoader;

public class ResourceMetaDataIterator
implements MetaDataIterator {
    private List _urls = null;
    private int _url = -1;

    public ResourceMetaDataIterator(String rsrc) throws IOException {
        this(rsrc, null);
    }

    public ResourceMetaDataIterator(String rsrc, ClassLoader loader) throws IOException {
        if (loader == null) {
            MultiClassLoader multi = new MultiClassLoader();
            multi.addClassLoader(MultiClassLoader.SYSTEM_LOADER);
            multi.addClassLoader(MultiClassLoader.THREAD_LOADER);
            multi.addClassLoader(this.getClass().getClassLoader());
            loader = multi;
        }
        Enumeration<URL> e = loader.getResources(rsrc);
        while (e.hasMoreElements()) {
            if (this._urls == null) {
                this._urls = new ArrayList(3);
            }
            this._urls.add(e.nextElement());
        }
    }

    public boolean hasNext() {
        return this._urls != null && this._url + 1 < this._urls.size();
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this._urls.get(++this._url);
    }

    public InputStream getInputStream() throws IOException {
        if (this._url == -1 || this._url >= this._urls.size()) {
            throw new IllegalStateException();
        }
        return ((URL)this._urls.get(this._url)).openStream();
    }

    public File getFile() throws IOException {
        if (this._url == -1 || this._url >= this._urls.size()) {
            throw new IllegalStateException();
        }
        File file = new File(URLDecoder.decode(((URL)this._urls.get(this._url)).getFile()));
        return file.exists() ? file : null;
    }

    public void close() {
    }
}

