/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.openjpa.lib.util.EventManager;

public abstract class AbstractEventManager
implements EventManager {
    private static Exception[] EMPTY_EXCEPTIONS = new Exception[0];
    private boolean _firing = false;
    private Collection _listeners = null;
    private Collection _newListeners = null;

    public synchronized void addListener(Object listener) {
        if (listener == null) {
            return;
        }
        if (this._firing) {
            if (this._newListeners == null) {
                this._newListeners = this.newListenerCollection();
                this._newListeners.addAll(this._listeners);
            }
            this._newListeners.add(listener);
        } else {
            if (this._listeners == null) {
                this._listeners = this.newListenerCollection();
            }
            this._listeners.add(listener);
        }
    }

    public synchronized boolean removeListener(Object listener) {
        if (listener == null) {
            return false;
        }
        if (this._firing && this._listeners.contains(listener)) {
            if (this._newListeners == null) {
                this._newListeners = this.newListenerCollection();
                this._newListeners.addAll(this._listeners);
            }
            return this._newListeners.remove(listener);
        }
        return this._listeners != null && this._listeners.remove(listener);
    }

    public synchronized boolean hasListener(Object listener) {
        return this._listeners != null && this._listeners.contains(listener);
    }

    public synchronized boolean hasListeners() {
        return this._listeners != null && !this._listeners.isEmpty();
    }

    public synchronized Collection getListeners() {
        return this._listeners == null ? Collections.EMPTY_LIST : Collections.unmodifiableCollection(this._listeners);
    }

    public synchronized Exception[] fireEvent(Object event) {
        if (this._listeners == null || this._listeners.isEmpty()) {
            return EMPTY_EXCEPTIONS;
        }
        boolean reentrant = this._firing;
        this._firing = true;
        LinkedList<Exception> exceptions = null;
        Iterator itr = this._listeners.iterator();
        while (itr.hasNext()) {
            try {
                this.fireEvent(event, itr.next());
            }
            catch (Exception e) {
                if (exceptions == null) {
                    exceptions = new LinkedList<Exception>();
                }
                exceptions.add(e);
            }
        }
        if (!reentrant) {
            this._firing = false;
            if (this._newListeners != null) {
                this._listeners = this._newListeners;
            }
            this._newListeners = null;
        }
        if (exceptions == null) {
            return EMPTY_EXCEPTIONS;
        }
        return exceptions.toArray(new Exception[exceptions.size()]);
    }

    protected abstract void fireEvent(Object var1, Object var2) throws Exception;

    protected Collection newListenerCollection() {
        return new LinkedList();
    }
}

