/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.lang.reflect.Method;
import java.util.Collection;
import org.apache.openjpa.event.LifecycleCallbacks;
import org.apache.openjpa.event.MethodLifecycleCallbacks;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.MetaDataDefaults;
import org.apache.openjpa.persistence.MetaDataTag;
import org.apache.openjpa.persistence.PersistenceMetaDataDefaults;
import org.apache.openjpa.util.UserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MetaDataParsers {
    private static final Localizer _loc = Localizer.forPackage(MetaDataParsers.class);

    MetaDataParsers() {
    }

    public static int[] getEventTypes(MetaDataTag tag) {
        switch (tag) {
            case PRE_PERSIST: {
                return new int[]{0};
            }
            case POST_PERSIST: {
                return new int[]{1};
            }
            case PRE_REMOVE: {
                return new int[]{7};
            }
            case POST_REMOVE: {
                return new int[]{8};
            }
            case PRE_UPDATE: {
                return new int[]{3};
            }
            case POST_UPDATE: {
                return new int[]{4};
            }
            case POST_LOAD: {
                return new int[]{2, 17};
            }
        }
        return null;
    }

    public static void validateMethodsForSameCallback(Class cls, Collection<LifecycleCallbacks> callbacks, Method method, MetaDataTag tag, MetaDataDefaults def, Log log) {
        if (callbacks == null || callbacks.isEmpty()) {
            return;
        }
        for (LifecycleCallbacks lc : callbacks) {
            Method exists;
            if (!(lc instanceof MethodLifecycleCallbacks) || !(exists = ((MethodLifecycleCallbacks)lc).getCallbackMethod()).getDeclaringClass().equals(method.getDeclaringClass())) continue;
            PersistenceMetaDataDefaults defaults = MetaDataParsers.getPersistenceDefaults(def);
            Localizer.Message msg = _loc.get("multiple-methods-on-callback", new Object[]{method.getDeclaringClass().getName(), method.getName(), exists.getName(), tag.toString()});
            if (defaults == null || defaults.getAllowsMultipleMethodsForSameCallback()) {
                log.warn(msg);
                continue;
            }
            throw new UserException(msg);
        }
    }

    private static PersistenceMetaDataDefaults getPersistenceDefaults(MetaDataDefaults def) {
        if (def instanceof PersistenceMetaDataDefaults) {
            return (PersistenceMetaDataDefaults)def;
        }
        return null;
    }
}

