/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import org.apache.openjpa.conf.OpenJPAConfigurationImpl;
import org.apache.openjpa.enhance.PCClassFileTransformer;
import org.apache.openjpa.kernel.Bootstrap;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.lib.conf.ConfigurationProvider;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.PersistenceExceptions;
import org.apache.openjpa.persistence.PersistenceProductDerivation;
import org.apache.openjpa.util.ClassResolver;

public class PersistenceProviderImpl
implements PersistenceProvider {
    static final String CLASS_TRANSFORMER_OPTIONS = "ClassTransformerOptions";

    public EntityManagerFactory createEntityManagerFactory(String name, String resource, Map m) {
        PersistenceProductDerivation pd = new PersistenceProductDerivation();
        try {
            ConfigurationProvider cp = pd.load(resource, name, m);
            if (cp == null) {
                return null;
            }
            BrokerFactory factory = Bootstrap.newBrokerFactory(cp, null);
            return OpenJPAPersistence.toEntityManagerFactory(factory);
        }
        catch (Exception e) {
            throw PersistenceExceptions.toPersistenceException(e);
        }
    }

    public EntityManagerFactory createEntityManagerFactory(String name, Map m) {
        return this.createEntityManagerFactory(name, null, m);
    }

    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo pui, Map m) {
        PersistenceProductDerivation pd = new PersistenceProductDerivation();
        try {
            ConfigurationProvider cp = pd.load(pui, m);
            if (cp == null) {
                return null;
            }
            String ctOpts = (String)Configurations.getProperty(CLASS_TRANSFORMER_OPTIONS, pui.getProperties());
            pui.addTransformer((ClassTransformer)new ClassTransformerImpl(cp, ctOpts, pui.getNewTempClassLoader()));
            if (!Configurations.containsProperty("BrokerImpl", cp.getProperties())) {
                cp.addProperty("openjpa.BrokerImpl", "non-finalizing");
            }
            BrokerFactory factory = Bootstrap.newBrokerFactory(cp, pui.getClassLoader());
            return OpenJPAPersistence.toEntityManagerFactory(factory);
        }
        catch (Exception e) {
            throw PersistenceExceptions.toPersistenceException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassTransformerImpl
    implements ClassTransformer {
        private final ClassFileTransformer _trans;

        private ClassTransformerImpl(ConfigurationProvider cp, String props, final ClassLoader tmpLoader) {
            OpenJPAConfigurationImpl conf = new OpenJPAConfigurationImpl();
            cp.setInto(conf);
            conf.setConnectionUserName(null);
            conf.setConnectionPassword(null);
            conf.setConnectionURL(null);
            conf.setConnectionDriverName(null);
            conf.setConnectionFactoryName(null);
            conf.setClassResolver(new ClassResolver(){

                public ClassLoader getClassLoader(Class context, ClassLoader env) {
                    return tmpLoader;
                }
            });
            conf.setReadOnly(true);
            MetaDataRepository repos = conf.getMetaDataRepositoryInstance();
            repos.setResolve(2, false);
            this._trans = new PCClassFileTransformer(repos, Configurations.parseProperties(props), tmpLoader);
        }

        public byte[] transform(ClassLoader cl, String name, Class<?> previousVersion, ProtectionDomain pd, byte[] bytes) throws IllegalClassFormatException {
            return this._trans.transform(cl, name, previousVersion, pd, bytes);
        }
    }
}

