/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.domain;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.springframework.security.acls.AclFormattingUtils;
import org.springframework.security.acls.Permission;
import org.springframework.security.acls.domain.CumulativePermission;
import org.springframework.util.Assert;

public final class BasePermission
implements Permission {
    public static final Permission READ = new BasePermission(1, 'R');
    public static final Permission WRITE = new BasePermission(2, 'W');
    public static final Permission CREATE = new BasePermission(4, 'C');
    public static final Permission DELETE = new BasePermission(8, 'D');
    public static final Permission ADMINISTRATION = new BasePermission(16, 'A');
    private static Map locallyDeclaredPermissionsByInteger = new HashMap();
    private static Map locallyDeclaredPermissionsByName = new HashMap();
    private char code;
    private int mask;
    static /* synthetic */ Class class$org$springframework$security$acls$domain$BasePermission;

    private BasePermission(int mask, char code) {
        this.mask = mask;
        this.code = code;
    }

    public static Permission buildFromMask(int mask) {
        if (locallyDeclaredPermissionsByInteger.containsKey(new Integer(mask))) {
            return (Permission)locallyDeclaredPermissionsByInteger.get(new Integer(mask));
        }
        CumulativePermission permission = new CumulativePermission();
        for (int i = 0; i < 32; ++i) {
            int permissionToCheck = 1 << i;
            if ((mask & permissionToCheck) != permissionToCheck) continue;
            Permission p = (Permission)locallyDeclaredPermissionsByInteger.get(new Integer(permissionToCheck));
            Assert.state((p != null ? 1 : 0) != 0, (String)("Mask " + permissionToCheck + " does not have a corresponding static BasePermission"));
            permission.set(p);
        }
        return permission;
    }

    public static Permission[] buildFromMask(int[] masks) {
        if (masks == null || masks.length == 0) {
            return new Permission[0];
        }
        Permission[] permissions = new Permission[masks.length];
        for (int i = 0; i < masks.length; ++i) {
            permissions[i] = BasePermission.buildFromMask(masks[i]);
        }
        return permissions;
    }

    public static Permission buildFromName(String name) {
        Assert.isTrue((boolean)locallyDeclaredPermissionsByName.containsKey(name), (String)("Unknown permission '" + name + "'"));
        return (Permission)locallyDeclaredPermissionsByName.get(name);
    }

    public static Permission[] buildFromName(String[] names) {
        if (names == null || names.length == 0) {
            return new Permission[0];
        }
        Permission[] permissions = new Permission[names.length];
        for (int i = 0; i < names.length; ++i) {
            permissions[i] = BasePermission.buildFromName(names[i]);
        }
        return permissions;
    }

    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (!(arg0 instanceof Permission)) {
            return false;
        }
        Permission rhs = (Permission)arg0;
        return this.mask == rhs.getMask();
    }

    public int getMask() {
        return this.mask;
    }

    public String getPattern() {
        return AclFormattingUtils.printBinary(this.mask, this.code);
    }

    public String toString() {
        return "BasePermission[" + this.getPattern() + "=" + this.mask + "]";
    }

    public int hashCode() {
        return this.mask;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Field[] fields = (class$org$springframework$security$acls$domain$BasePermission == null ? (class$org$springframework$security$acls$domain$BasePermission = BasePermission.class$("org.springframework.security.acls.domain.BasePermission")) : class$org$springframework$security$acls$domain$BasePermission).getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                Object fieldValue = fields[i].get(null);
                if (!(class$org$springframework$security$acls$domain$BasePermission == null ? BasePermission.class$("org.springframework.security.acls.domain.BasePermission") : class$org$springframework$security$acls$domain$BasePermission).isAssignableFrom(fieldValue.getClass())) continue;
                BasePermission perm = (BasePermission)fieldValue;
                locallyDeclaredPermissionsByInteger.put(new Integer(perm.getMask()), perm);
                locallyDeclaredPermissionsByName.put(fields[i].getName(), perm);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

